/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcesearch.model.SearchDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SearchResourcesRequest
extends BmcRequest<SearchDetails> {
    private SearchDetails searchDetails;
    private Integer limit;
    private String page;
    private String tenantId;
    private String opcRequestId;

    public SearchDetails getSearchDetails() {
        return this.searchDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public SearchDetails getBody$() {
        return this.searchDetails;
    }

    public Builder toBuilder() {
        return new Builder().searchDetails(this.searchDetails).limit(this.limit).page(this.page).tenantId(this.tenantId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",searchDetails=").append(String.valueOf((Object)this.searchDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",tenantId=").append(String.valueOf(this.tenantId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.searchDetails, (Object)other.searchDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.searchDetails == null ? 43 : this.searchDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SearchResourcesRequest, SearchDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private SearchDetails searchDetails = null;
        private Integer limit = null;
        private String page = null;
        private String tenantId = null;
        private String opcRequestId = null;

        public Builder searchDetails(SearchDetails searchDetails) {
            this.searchDetails = searchDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchResourcesRequest o) {
            this.searchDetails(o.getSearchDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.tenantId(o.getTenantId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchResourcesRequest build() {
            SearchResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SearchDetails body) {
            this.searchDetails(body);
            return this;
        }

        public SearchResourcesRequest buildWithoutInvocationCallback() {
            SearchResourcesRequest request = new SearchResourcesRequest();
            request.searchDetails = this.searchDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.tenantId = this.tenantId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

