/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.UpdateTemplateDetails;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTemplateRequest
extends BmcRequest<UpdateTemplateDetails> {
    private String templateId;
    private UpdateTemplateDetails updateTemplateDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getTemplateId() {
        return this.templateId;
    }

    public UpdateTemplateDetails getUpdateTemplateDetails() {
        return this.updateTemplateDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateTemplateDetails getBody$() {
        return this.updateTemplateDetails;
    }

    public Builder toBuilder() {
        return new Builder().templateId(this.templateId).updateTemplateDetails(this.updateTemplateDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",templateId=").append(String.valueOf(this.templateId));
        sb.append(",updateTemplateDetails=").append(String.valueOf((Object)this.updateTemplateDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.templateId, other.templateId) && Objects.equals((Object)this.updateTemplateDetails, (Object)other.updateTemplateDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.templateId == null ? 43 : this.templateId.hashCode());
        result = result * 59 + (this.updateTemplateDetails == null ? 43 : this.updateTemplateDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTemplateRequest, UpdateTemplateDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String templateId = null;
        private UpdateTemplateDetails updateTemplateDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder updateTemplateDetails(UpdateTemplateDetails updateTemplateDetails) {
            this.updateTemplateDetails = updateTemplateDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTemplateRequest o) {
            this.templateId(o.getTemplateId());
            this.updateTemplateDetails(o.getUpdateTemplateDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTemplateRequest build() {
            UpdateTemplateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTemplateDetails body) {
            this.updateTemplateDetails(body);
            return this;
        }

        public UpdateTemplateRequest buildWithoutInvocationCallback() {
            UpdateTemplateRequest request = new UpdateTemplateRequest();
            request.templateId = this.templateId;
            request.updateTemplateDetails = this.updateTemplateDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

