/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPrivateEndpointsRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String compartmentId;
    private String privateEndpointId;
    private String displayName;
    private String vcnId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).compartmentId(this.compartmentId).privateEndpointId(this.privateEndpointId).displayName(this.displayName).vcnId(this.vcnId).sortBy(this.sortBy).sortOrder(this.sortOrder).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",vcnId=").append(String.valueOf(this.vcnId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPrivateEndpointsRequest)) {
            return false;
        }
        ListPrivateEndpointsRequest other = (ListPrivateEndpointsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPrivateEndpointsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String compartmentId = null;
        private String privateEndpointId = null;
        private String displayName = null;
        private String vcnId = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPrivateEndpointsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.privateEndpointId(o.getPrivateEndpointId());
            this.displayName(o.getDisplayName());
            this.vcnId(o.getVcnId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPrivateEndpointsRequest build() {
            ListPrivateEndpointsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPrivateEndpointsRequest buildWithoutInvocationCallback() {
            ListPrivateEndpointsRequest request = new ListPrivateEndpointsRequest();
            request.opcRequestId = this.opcRequestId;
            request.compartmentId = this.compartmentId;
            request.privateEndpointId = this.privateEndpointId;
            request.displayName = this.displayName;
            request.vcnId = this.vcnId;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

