/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcemanager.model.ApplyJobPlanResolution;
import com.oracle.bmc.resourcemanager.model.CancellationDetails;
import com.oracle.bmc.resourcemanager.model.ConfigSourceRecord;
import com.oracle.bmc.resourcemanager.model.FailureDetails;
import com.oracle.bmc.resourcemanager.model.JobOperationDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Job
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="stackId")
    private final String stackId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="operation")
    private final Operation operation;
    @JsonProperty(value="isThirdPartyProviderExperienceEnabled")
    private final Boolean isThirdPartyProviderExperienceEnabled;
    @JsonProperty(value="isProviderUpgradeRequired")
    private final Boolean isProviderUpgradeRequired;
    @JsonProperty(value="jobOperationDetails")
    private final JobOperationDetails jobOperationDetails;
    @JsonProperty(value="applyJobPlanResolution")
    private final ApplyJobPlanResolution applyJobPlanResolution;
    @JsonProperty(value="resolvedPlanJobId")
    private final String resolvedPlanJobId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="failureDetails")
    private final FailureDetails failureDetails;
    @JsonProperty(value="cancellationDetails")
    private final CancellationDetails cancellationDetails;
    @JsonProperty(value="workingDirectory")
    private final String workingDirectory;
    @JsonProperty(value="variables")
    private final Map<String, String> variables;
    @JsonProperty(value="configSource")
    private final ConfigSourceRecord configSource;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "stackId", "compartmentId", "displayName", "operation", "isThirdPartyProviderExperienceEnabled", "isProviderUpgradeRequired", "jobOperationDetails", "applyJobPlanResolution", "resolvedPlanJobId", "timeCreated", "timeFinished", "lifecycleState", "failureDetails", "cancellationDetails", "workingDirectory", "variables", "configSource", "freeformTags", "definedTags"})
    public Job(String id, String stackId, String compartmentId, String displayName, Operation operation, Boolean isThirdPartyProviderExperienceEnabled, Boolean isProviderUpgradeRequired, JobOperationDetails jobOperationDetails, ApplyJobPlanResolution applyJobPlanResolution, String resolvedPlanJobId, Date timeCreated, Date timeFinished, LifecycleState lifecycleState, FailureDetails failureDetails, CancellationDetails cancellationDetails, String workingDirectory, Map<String, String> variables, ConfigSourceRecord configSource, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.stackId = stackId;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.operation = operation;
        this.isThirdPartyProviderExperienceEnabled = isThirdPartyProviderExperienceEnabled;
        this.isProviderUpgradeRequired = isProviderUpgradeRequired;
        this.jobOperationDetails = jobOperationDetails;
        this.applyJobPlanResolution = applyJobPlanResolution;
        this.resolvedPlanJobId = resolvedPlanJobId;
        this.timeCreated = timeCreated;
        this.timeFinished = timeFinished;
        this.lifecycleState = lifecycleState;
        this.failureDetails = failureDetails;
        this.cancellationDetails = cancellationDetails;
        this.workingDirectory = workingDirectory;
        this.variables = variables;
        this.configSource = configSource;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Boolean getIsThirdPartyProviderExperienceEnabled() {
        return this.isThirdPartyProviderExperienceEnabled;
    }

    public Boolean getIsProviderUpgradeRequired() {
        return this.isProviderUpgradeRequired;
    }

    public JobOperationDetails getJobOperationDetails() {
        return this.jobOperationDetails;
    }

    public ApplyJobPlanResolution getApplyJobPlanResolution() {
        return this.applyJobPlanResolution;
    }

    public String getResolvedPlanJobId() {
        return this.resolvedPlanJobId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public FailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    public CancellationDetails getCancellationDetails() {
        return this.cancellationDetails;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public ConfigSourceRecord getConfigSource() {
        return this.configSource;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Job(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", stackId=").append(String.valueOf(this.stackId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", operation=").append(String.valueOf((Object)this.operation));
        sb.append(", isThirdPartyProviderExperienceEnabled=").append(String.valueOf(this.isThirdPartyProviderExperienceEnabled));
        sb.append(", isProviderUpgradeRequired=").append(String.valueOf(this.isProviderUpgradeRequired));
        sb.append(", jobOperationDetails=").append(String.valueOf((Object)this.jobOperationDetails));
        sb.append(", applyJobPlanResolution=").append(String.valueOf((Object)this.applyJobPlanResolution));
        sb.append(", resolvedPlanJobId=").append(String.valueOf(this.resolvedPlanJobId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", failureDetails=").append(String.valueOf((Object)this.failureDetails));
        sb.append(", cancellationDetails=").append(String.valueOf((Object)this.cancellationDetails));
        sb.append(", workingDirectory=").append(String.valueOf(this.workingDirectory));
        sb.append(", variables=").append(String.valueOf(this.variables));
        sb.append(", configSource=").append(String.valueOf((Object)this.configSource));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.stackId, other.stackId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.operation, (Object)other.operation) && Objects.equals(this.isThirdPartyProviderExperienceEnabled, other.isThirdPartyProviderExperienceEnabled) && Objects.equals(this.isProviderUpgradeRequired, other.isProviderUpgradeRequired) && Objects.equals((Object)this.jobOperationDetails, (Object)other.jobOperationDetails) && Objects.equals((Object)this.applyJobPlanResolution, (Object)other.applyJobPlanResolution) && Objects.equals(this.resolvedPlanJobId, other.resolvedPlanJobId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.failureDetails, (Object)other.failureDetails) && Objects.equals((Object)this.cancellationDetails, (Object)other.cancellationDetails) && Objects.equals(this.workingDirectory, other.workingDirectory) && Objects.equals(this.variables, other.variables) && Objects.equals((Object)this.configSource, (Object)other.configSource) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.isThirdPartyProviderExperienceEnabled == null ? 43 : this.isThirdPartyProviderExperienceEnabled.hashCode());
        result = result * 59 + (this.isProviderUpgradeRequired == null ? 43 : this.isProviderUpgradeRequired.hashCode());
        result = result * 59 + (this.jobOperationDetails == null ? 43 : this.jobOperationDetails.hashCode());
        result = result * 59 + (this.applyJobPlanResolution == null ? 43 : this.applyJobPlanResolution.hashCode());
        result = result * 59 + (this.resolvedPlanJobId == null ? 43 : this.resolvedPlanJobId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.failureDetails == null ? 43 : this.failureDetails.hashCode());
        result = result * 59 + (this.cancellationDetails == null ? 43 : this.cancellationDetails.hashCode());
        result = result * 59 + (this.workingDirectory == null ? 43 : this.workingDirectory.hashCode());
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        result = result * 59 + (this.configSource == null ? 43 : this.configSource.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Operation implements BmcEnum
    {
        Plan("PLAN"),
        Apply("APPLY"),
        Destroy("DESTROY"),
        ImportTfState("IMPORT_TF_STATE"),
        PlanRollback("PLAN_ROLLBACK"),
        ApplyRollback("APPLY_ROLLBACK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operation> map;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operation.class);
            map = new HashMap<String, Operation>();
            for (Operation v : Operation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="stackId")
        private String stackId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="operation")
        private Operation operation;
        @JsonProperty(value="isThirdPartyProviderExperienceEnabled")
        private Boolean isThirdPartyProviderExperienceEnabled;
        @JsonProperty(value="isProviderUpgradeRequired")
        private Boolean isProviderUpgradeRequired;
        @JsonProperty(value="jobOperationDetails")
        private JobOperationDetails jobOperationDetails;
        @JsonProperty(value="applyJobPlanResolution")
        private ApplyJobPlanResolution applyJobPlanResolution;
        @JsonProperty(value="resolvedPlanJobId")
        private String resolvedPlanJobId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="failureDetails")
        private FailureDetails failureDetails;
        @JsonProperty(value="cancellationDetails")
        private CancellationDetails cancellationDetails;
        @JsonProperty(value="workingDirectory")
        private String workingDirectory;
        @JsonProperty(value="variables")
        private Map<String, String> variables;
        @JsonProperty(value="configSource")
        private ConfigSourceRecord configSource;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            this.__explicitlySet__.add("stackId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder isThirdPartyProviderExperienceEnabled(Boolean isThirdPartyProviderExperienceEnabled) {
            this.isThirdPartyProviderExperienceEnabled = isThirdPartyProviderExperienceEnabled;
            this.__explicitlySet__.add("isThirdPartyProviderExperienceEnabled");
            return this;
        }

        public Builder isProviderUpgradeRequired(Boolean isProviderUpgradeRequired) {
            this.isProviderUpgradeRequired = isProviderUpgradeRequired;
            this.__explicitlySet__.add("isProviderUpgradeRequired");
            return this;
        }

        public Builder jobOperationDetails(JobOperationDetails jobOperationDetails) {
            this.jobOperationDetails = jobOperationDetails;
            this.__explicitlySet__.add("jobOperationDetails");
            return this;
        }

        public Builder applyJobPlanResolution(ApplyJobPlanResolution applyJobPlanResolution) {
            this.applyJobPlanResolution = applyJobPlanResolution;
            this.__explicitlySet__.add("applyJobPlanResolution");
            return this;
        }

        public Builder resolvedPlanJobId(String resolvedPlanJobId) {
            this.resolvedPlanJobId = resolvedPlanJobId;
            this.__explicitlySet__.add("resolvedPlanJobId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            this.__explicitlySet__.add("failureDetails");
            return this;
        }

        public Builder cancellationDetails(CancellationDetails cancellationDetails) {
            this.cancellationDetails = cancellationDetails;
            this.__explicitlySet__.add("cancellationDetails");
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            this.__explicitlySet__.add("workingDirectory");
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public Builder configSource(ConfigSourceRecord configSource) {
            this.configSource = configSource;
            this.__explicitlySet__.add("configSource");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Job build() {
            Job model = new Job(this.id, this.stackId, this.compartmentId, this.displayName, this.operation, this.isThirdPartyProviderExperienceEnabled, this.isProviderUpgradeRequired, this.jobOperationDetails, this.applyJobPlanResolution, this.resolvedPlanJobId, this.timeCreated, this.timeFinished, this.lifecycleState, this.failureDetails, this.cancellationDetails, this.workingDirectory, this.variables, this.configSource, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Job model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("stackId")) {
                this.stackId(model.getStackId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("isThirdPartyProviderExperienceEnabled")) {
                this.isThirdPartyProviderExperienceEnabled(model.getIsThirdPartyProviderExperienceEnabled());
            }
            if (model.wasPropertyExplicitlySet("isProviderUpgradeRequired")) {
                this.isProviderUpgradeRequired(model.getIsProviderUpgradeRequired());
            }
            if (model.wasPropertyExplicitlySet("jobOperationDetails")) {
                this.jobOperationDetails(model.getJobOperationDetails());
            }
            if (model.wasPropertyExplicitlySet("applyJobPlanResolution")) {
                this.applyJobPlanResolution(model.getApplyJobPlanResolution());
            }
            if (model.wasPropertyExplicitlySet("resolvedPlanJobId")) {
                this.resolvedPlanJobId(model.getResolvedPlanJobId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("failureDetails")) {
                this.failureDetails(model.getFailureDetails());
            }
            if (model.wasPropertyExplicitlySet("cancellationDetails")) {
                this.cancellationDetails(model.getCancellationDetails());
            }
            if (model.wasPropertyExplicitlySet("workingDirectory")) {
                this.workingDirectory(model.getWorkingDirectory());
            }
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            if (model.wasPropertyExplicitlySet("configSource")) {
                this.configSource(model.getConfigSource());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

