/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FailureDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="code")
    private final Code code;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"code", "message"})
    public FailureDetails(Code code, String message) {
        this.code = code;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Code getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FailureDetails(");
        sb.append("super=").append(super.toString());
        sb.append("code=").append(String.valueOf((Object)this.code));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)((Object)o);
        return Objects.equals((Object)this.code, (Object)other.code) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.code == null ? 43 : this.code.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Code implements BmcEnum
    {
        InternalServiceError("INTERNAL_SERVICE_ERROR"),
        TerraformExecutionError("TERRAFORM_EXECUTION_ERROR"),
        TerraformConfigUnzipFailed("TERRAFORM_CONFIG_UNZIP_FAILED"),
        InvalidWorkingDirectory("INVALID_WORKING_DIRECTORY"),
        JobTimeout("JOB_TIMEOUT"),
        TerraformConfigVirusFound("TERRAFORM_CONFIG_VIRUS_FOUND"),
        TerraformGitCloneFailure("TERRAFORM_GIT_CLONE_FAILURE"),
        TerraformGitCheckoutFailure("TERRAFORM_GIT_CHECKOUT_FAILURE"),
        TerraformObjectStorageConfigSourceEmptyBucket("TERRAFORM_OBJECT_STORAGE_CONFIG_SOURCE_EMPTY_BUCKET"),
        TerraformObjectStorageConfigSourceNoTfFilePresent("TERRAFORM_OBJECT_STORAGE_CONFIG_SOURCE_NO_TF_FILE_PRESENT"),
        TerraformObjectStorageConfigSourceUnsupportedObjectSize("TERRAFORM_OBJECT_STORAGE_CONFIG_SOURCE_UNSUPPORTED_OBJECT_SIZE"),
        CustomTerraformProviderBucketNotFound("CUSTOM_TERRAFORM_PROVIDER_BUCKET_NOT_FOUND"),
        CustomTerraformProviderUnsupportedObjectSize("CUSTOM_TERRAFORM_PROVIDER_UNSUPPORTED_OBJECT_SIZE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Code> map;

        private Code(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Code create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Code', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Code.class);
            map = new HashMap<String, Code>();
            for (Code v : Code.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="code")
        private Code code;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder code(Code code) {
            this.code = code;
            this.__explicitlySet__.add("code");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public FailureDetails build() {
            FailureDetails model = new FailureDetails(this.code, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FailureDetails model) {
            if (model.wasPropertyExplicitlySet("code")) {
                this.code(model.getCode());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

