/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.resourcemanager.model.ConfigSource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class DevOpsConfigSource
extends ConfigSource {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="branchName")
    private final String branchName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DevOpsConfigSource(String workingDirectory, String projectId, String repositoryId, String branchName) {
        super(workingDirectory);
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.branchName = branchName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DevOpsConfigSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", branchName=").append(String.valueOf(this.branchName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevOpsConfigSource)) {
            return false;
        }
        DevOpsConfigSource other = (DevOpsConfigSource)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.branchName, other.branchName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.branchName == null ? 43 : this.branchName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workingDirectory")
        private String workingDirectory;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="branchName")
        private String branchName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            this.__explicitlySet__.add("workingDirectory");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder branchName(String branchName) {
            this.branchName = branchName;
            this.__explicitlySet__.add("branchName");
            return this;
        }

        public DevOpsConfigSource build() {
            DevOpsConfigSource model = new DevOpsConfigSource(this.workingDirectory, this.projectId, this.repositoryId, this.branchName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DevOpsConfigSource model) {
            if (model.wasPropertyExplicitlySet("workingDirectory")) {
                this.workingDirectory(model.getWorkingDirectory());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("branchName")) {
                this.branchName(model.getBranchName());
            }
            return this;
        }
    }
}

