/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociatedResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="attributes")
    private final Map<String, String> attributes;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="resourceAddress")
    private final String resourceAddress;

    @Deprecated
    @ConstructorProperties(value={"resourceId", "resourceName", "resourceType", "attributes", "timeCreated", "region", "resourceAddress"})
    public AssociatedResourceSummary(String resourceId, String resourceName, String resourceType, Map<String, String> attributes, Date timeCreated, String region, String resourceAddress) {
        this.resourceId = resourceId;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.attributes = attributes;
        this.timeCreated = timeCreated;
        this.region = region;
        this.resourceAddress = resourceAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociatedResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", attributes=").append(String.valueOf(this.attributes));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", resourceAddress=").append(String.valueOf(this.resourceAddress));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociatedResourceSummary)) {
            return false;
        }
        AssociatedResourceSummary other = (AssociatedResourceSummary)((Object)o);
        return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.region, other.region) && Objects.equals(this.resourceAddress, other.resourceAddress) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.attributes == null ? 43 : this.attributes.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.resourceAddress == null ? 43 : this.resourceAddress.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="attributes")
        private Map<String, String> attributes;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="resourceAddress")
        private String resourceAddress;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            this.__explicitlySet__.add("attributes");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder resourceAddress(String resourceAddress) {
            this.resourceAddress = resourceAddress;
            this.__explicitlySet__.add("resourceAddress");
            return this;
        }

        public AssociatedResourceSummary build() {
            AssociatedResourceSummary model = new AssociatedResourceSummary(this.resourceId, this.resourceName, this.resourceType, this.attributes, this.timeCreated, this.region, this.resourceAddress);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociatedResourceSummary model) {
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("attributes")) {
                this.attributes(model.getAttributes());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("resourceAddress")) {
                this.resourceAddress(model.getResourceAddress());
            }
            return this;
        }
    }
}

