/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubsubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Commitment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="quantity")
    private final String quantity;
    @JsonProperty(value="availableAmount")
    private final String availableAmount;
    @JsonProperty(value="lineNetAmount")
    private final String lineNetAmount;
    @JsonProperty(value="fundedAllocationValue")
    private final String fundedAllocationValue;

    @Deprecated
    @ConstructorProperties(value={"timeStart", "timeEnd", "quantity", "availableAmount", "lineNetAmount", "fundedAllocationValue"})
    public Commitment(Date timeStart, Date timeEnd, String quantity, String availableAmount, String lineNetAmount, String fundedAllocationValue) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.quantity = quantity;
        this.availableAmount = availableAmount;
        this.lineNetAmount = lineNetAmount;
        this.fundedAllocationValue = fundedAllocationValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getAvailableAmount() {
        return this.availableAmount;
    }

    public String getLineNetAmount() {
        return this.lineNetAmount;
    }

    public String getFundedAllocationValue() {
        return this.fundedAllocationValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Commitment(");
        sb.append("super=").append(super.toString());
        sb.append("timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", availableAmount=").append(String.valueOf(this.availableAmount));
        sb.append(", lineNetAmount=").append(String.valueOf(this.lineNetAmount));
        sb.append(", fundedAllocationValue=").append(String.valueOf(this.fundedAllocationValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Commitment)) {
            return false;
        }
        Commitment other = (Commitment)((Object)o);
        return Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.availableAmount, other.availableAmount) && Objects.equals(this.lineNetAmount, other.lineNetAmount) && Objects.equals(this.fundedAllocationValue, other.fundedAllocationValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.availableAmount == null ? 43 : this.availableAmount.hashCode());
        result = result * 59 + (this.lineNetAmount == null ? 43 : this.lineNetAmount.hashCode());
        result = result * 59 + (this.fundedAllocationValue == null ? 43 : this.fundedAllocationValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="quantity")
        private String quantity;
        @JsonProperty(value="availableAmount")
        private String availableAmount;
        @JsonProperty(value="lineNetAmount")
        private String lineNetAmount;
        @JsonProperty(value="fundedAllocationValue")
        private String fundedAllocationValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder availableAmount(String availableAmount) {
            this.availableAmount = availableAmount;
            this.__explicitlySet__.add("availableAmount");
            return this;
        }

        public Builder lineNetAmount(String lineNetAmount) {
            this.lineNetAmount = lineNetAmount;
            this.__explicitlySet__.add("lineNetAmount");
            return this;
        }

        public Builder fundedAllocationValue(String fundedAllocationValue) {
            this.fundedAllocationValue = fundedAllocationValue;
            this.__explicitlySet__.add("fundedAllocationValue");
            return this;
        }

        public Commitment build() {
            Commitment model = new Commitment(this.timeStart, this.timeEnd, this.quantity, this.availableAmount, this.lineNetAmount, this.fundedAllocationValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Commitment model) {
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("availableAmount")) {
                this.availableAmount(model.getAvailableAmount());
            }
            if (model.wasPropertyExplicitlySet("lineNetAmount")) {
                this.lineNetAmount(model.getLineNetAmount());
            }
            if (model.wasPropertyExplicitlySet("fundedAllocationValue")) {
                this.fundedAllocationValue(model.getFundedAllocationValue());
            }
            return this;
        }
    }
}

