/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osuborganizationsubscription.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOrganizationSubscriptionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String subscriptionIds;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private String xOneOriginRegion;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getXOneOriginRegion() {
        return this.xOneOriginRegion;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).subscriptionIds(this.subscriptionIds).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).xOneOriginRegion(this.xOneOriginRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",subscriptionIds=").append(String.valueOf(this.subscriptionIds));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",xOneOriginRegion=").append(String.valueOf(this.xOneOriginRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOrganizationSubscriptionsRequest)) {
            return false;
        }
        ListOrganizationSubscriptionsRequest other = (ListOrganizationSubscriptionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionIds, other.subscriptionIds) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.xOneOriginRegion, other.xOneOriginRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionIds == null ? 43 : this.subscriptionIds.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.xOneOriginRegion == null ? 43 : this.xOneOriginRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOrganizationSubscriptionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String subscriptionIds = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private String xOneOriginRegion = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder subscriptionIds(String subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder xOneOriginRegion(String xOneOriginRegion) {
            this.xOneOriginRegion = xOneOriginRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOrganizationSubscriptionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.subscriptionIds(o.getSubscriptionIds());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.xOneOriginRegion(o.getXOneOriginRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOrganizationSubscriptionsRequest build() {
            ListOrganizationSubscriptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOrganizationSubscriptionsRequest buildWithoutInvocationCallback() {
            ListOrganizationSubscriptionsRequest request = new ListOrganizationSubscriptionsRequest();
            request.compartmentId = this.compartmentId;
            request.subscriptionIds = this.subscriptionIds;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.xOneOriginRegion = this.xOneOriginRegion;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Subscriptionid("SUBSCRIPTIONID"),
        Timestart("TIMESTART");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

