/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osuborganizationsubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osuborganizationsubscription.OrganizationSubscriptionAsync;
import com.oracle.bmc.osuborganizationsubscription.model.SubscriptionSummary;
import com.oracle.bmc.osuborganizationsubscription.requests.ListOrganizationSubscriptionsRequest;
import com.oracle.bmc.osuborganizationsubscription.responses.ListOrganizationSubscriptionsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationSubscriptionAsyncClient
extends BaseAsyncClient
implements OrganizationSubscriptionAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ORGANIZATIONSUBSCRIPTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://csaap-e.oracle.com").build();
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationSubscriptionAsyncClient.class);

    private OrganizationSubscriptionAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ListOrganizationSubscriptionsResponse> listOrganizationSubscriptions(ListOrganizationSubscriptionsRequest request, AsyncHandler<ListOrganizationSubscriptionsRequest, ListOrganizationSubscriptionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubscriptionIds(), "subscriptionIds is required");
        return this.clientCall(request, ListOrganizationSubscriptionsResponse::builder).logger(LOG, "listOrganizationSubscriptions").serviceDetails("OrganizationSubscription", "ListOrganizationSubscriptions", "").method(Method.GET).requestBuilder(ListOrganizationSubscriptionsRequest::builder).basePath("/oalapp/service/onesubs/proxy/20210501").appendPathParam("organizationSubscription").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionIds", (Object)request.getSubscriptionIds()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("x-one-origin-region", request.getXOneOriginRegion()).handleBodyList(SubscriptionSummary.class, ListOrganizationSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListOrganizationSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationSubscriptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OrganizationSubscriptionAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OrganizationSubscriptionAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OrganizationSubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OrganizationSubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OrganizationSubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OrganizationSubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrganizationSubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OrganizationSubscriptionAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OrganizationSubscriptionAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OrganizationSubscriptionAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

