/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ospgateway.model.PayInvoiceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PayInvoiceRequest
extends BmcRequest<PayInvoiceDetails> {
    private String ospHomeRegion;
    private String internalInvoiceId;
    private String compartmentId;
    private PayInvoiceDetails payInvoiceDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getInternalInvoiceId() {
        return this.internalInvoiceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public PayInvoiceDetails getPayInvoiceDetails() {
        return this.payInvoiceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PayInvoiceDetails getBody$() {
        return this.payInvoiceDetails;
    }

    public Builder toBuilder() {
        return new Builder().ospHomeRegion(this.ospHomeRegion).internalInvoiceId(this.internalInvoiceId).compartmentId(this.compartmentId).payInvoiceDetails(this.payInvoiceDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",internalInvoiceId=").append(String.valueOf(this.internalInvoiceId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",payInvoiceDetails=").append(String.valueOf((Object)this.payInvoiceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayInvoiceRequest)) {
            return false;
        }
        PayInvoiceRequest other = (PayInvoiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.internalInvoiceId, other.internalInvoiceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.payInvoiceDetails, (Object)other.payInvoiceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.internalInvoiceId == null ? 43 : this.internalInvoiceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.payInvoiceDetails == null ? 43 : this.payInvoiceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PayInvoiceRequest, PayInvoiceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ospHomeRegion = null;
        private String internalInvoiceId = null;
        private String compartmentId = null;
        private PayInvoiceDetails payInvoiceDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder internalInvoiceId(String internalInvoiceId) {
            this.internalInvoiceId = internalInvoiceId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder payInvoiceDetails(PayInvoiceDetails payInvoiceDetails) {
            this.payInvoiceDetails = payInvoiceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PayInvoiceRequest o) {
            this.ospHomeRegion(o.getOspHomeRegion());
            this.internalInvoiceId(o.getInternalInvoiceId());
            this.compartmentId(o.getCompartmentId());
            this.payInvoiceDetails(o.getPayInvoiceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PayInvoiceRequest build() {
            PayInvoiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PayInvoiceDetails body) {
            this.payInvoiceDetails(body);
            return this;
        }

        public PayInvoiceRequest buildWithoutInvocationCallback() {
            PayInvoiceRequest request = new PayInvoiceRequest();
            request.ospHomeRegion = this.ospHomeRegion;
            request.internalInvoiceId = this.internalInvoiceId;
            request.compartmentId = this.compartmentId;
            request.payInvoiceDetails = this.payInvoiceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

