/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.BillingAddress;
import com.oracle.bmc.ospgateway.model.PaymentGateway;
import com.oracle.bmc.ospgateway.model.PaymentOption;
import com.oracle.bmc.ospgateway.model.TaxInfo;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscriptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="subscriptionPlanNumber")
    private final String subscriptionPlanNumber;
    @JsonProperty(value="planType")
    private final PlanType planType;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="shipToCustAcctSiteId")
    private final String shipToCustAcctSiteId;
    @JsonProperty(value="shipToCustAcctRoleId")
    private final String shipToCustAcctRoleId;
    @JsonProperty(value="billToCustAccountId")
    private final String billToCustAccountId;
    @JsonProperty(value="isIntentToPay")
    private final Boolean isIntentToPay;
    @JsonProperty(value="currencyCode")
    private final String currencyCode;
    @JsonProperty(value="gsiOrgCode")
    private final String gsiOrgCode;
    @JsonProperty(value="languageCode")
    private final String languageCode;
    @JsonProperty(value="organizationId")
    private final String organizationId;
    @JsonProperty(value="upgradeState")
    private final UpgradeState upgradeState;
    @JsonProperty(value="upgradeStateDetails")
    private final UpgradeStateDetails upgradeStateDetails;
    @JsonProperty(value="taxInfo")
    private final TaxInfo taxInfo;
    @JsonProperty(value="paymentOptions")
    private final List<PaymentOption> paymentOptions;
    @JsonProperty(value="paymentGateway")
    private final PaymentGateway paymentGateway;
    @JsonProperty(value="billingAddress")
    private final BillingAddress billingAddress;
    @JsonProperty(value="timePlanUpgrade")
    private final Date timePlanUpgrade;

    @Deprecated
    @ConstructorProperties(value={"id", "subscriptionPlanNumber", "planType", "timeStart", "shipToCustAcctSiteId", "shipToCustAcctRoleId", "billToCustAccountId", "isIntentToPay", "currencyCode", "gsiOrgCode", "languageCode", "organizationId", "upgradeState", "upgradeStateDetails", "taxInfo", "paymentOptions", "paymentGateway", "billingAddress", "timePlanUpgrade"})
    public SubscriptionSummary(String id, String subscriptionPlanNumber, PlanType planType, Date timeStart, String shipToCustAcctSiteId, String shipToCustAcctRoleId, String billToCustAccountId, Boolean isIntentToPay, String currencyCode, String gsiOrgCode, String languageCode, String organizationId, UpgradeState upgradeState, UpgradeStateDetails upgradeStateDetails, TaxInfo taxInfo, List<PaymentOption> paymentOptions, PaymentGateway paymentGateway, BillingAddress billingAddress, Date timePlanUpgrade) {
        this.id = id;
        this.subscriptionPlanNumber = subscriptionPlanNumber;
        this.planType = planType;
        this.timeStart = timeStart;
        this.shipToCustAcctSiteId = shipToCustAcctSiteId;
        this.shipToCustAcctRoleId = shipToCustAcctRoleId;
        this.billToCustAccountId = billToCustAccountId;
        this.isIntentToPay = isIntentToPay;
        this.currencyCode = currencyCode;
        this.gsiOrgCode = gsiOrgCode;
        this.languageCode = languageCode;
        this.organizationId = organizationId;
        this.upgradeState = upgradeState;
        this.upgradeStateDetails = upgradeStateDetails;
        this.taxInfo = taxInfo;
        this.paymentOptions = paymentOptions;
        this.paymentGateway = paymentGateway;
        this.billingAddress = billingAddress;
        this.timePlanUpgrade = timePlanUpgrade;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSubscriptionPlanNumber() {
        return this.subscriptionPlanNumber;
    }

    public PlanType getPlanType() {
        return this.planType;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public String getShipToCustAcctSiteId() {
        return this.shipToCustAcctSiteId;
    }

    public String getShipToCustAcctRoleId() {
        return this.shipToCustAcctRoleId;
    }

    public String getBillToCustAccountId() {
        return this.billToCustAccountId;
    }

    public Boolean getIsIntentToPay() {
        return this.isIntentToPay;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getGsiOrgCode() {
        return this.gsiOrgCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public UpgradeState getUpgradeState() {
        return this.upgradeState;
    }

    public UpgradeStateDetails getUpgradeStateDetails() {
        return this.upgradeStateDetails;
    }

    public TaxInfo getTaxInfo() {
        return this.taxInfo;
    }

    public List<PaymentOption> getPaymentOptions() {
        return this.paymentOptions;
    }

    public PaymentGateway getPaymentGateway() {
        return this.paymentGateway;
    }

    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    public Date getTimePlanUpgrade() {
        return this.timePlanUpgrade;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", subscriptionPlanNumber=").append(String.valueOf(this.subscriptionPlanNumber));
        sb.append(", planType=").append(String.valueOf((Object)this.planType));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", shipToCustAcctSiteId=").append(String.valueOf(this.shipToCustAcctSiteId));
        sb.append(", shipToCustAcctRoleId=").append(String.valueOf(this.shipToCustAcctRoleId));
        sb.append(", billToCustAccountId=").append(String.valueOf(this.billToCustAccountId));
        sb.append(", isIntentToPay=").append(String.valueOf(this.isIntentToPay));
        sb.append(", currencyCode=").append(String.valueOf(this.currencyCode));
        sb.append(", gsiOrgCode=").append(String.valueOf(this.gsiOrgCode));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(", organizationId=").append(String.valueOf(this.organizationId));
        sb.append(", upgradeState=").append(String.valueOf((Object)this.upgradeState));
        sb.append(", upgradeStateDetails=").append(String.valueOf((Object)this.upgradeStateDetails));
        sb.append(", taxInfo=").append(String.valueOf((Object)this.taxInfo));
        sb.append(", paymentOptions=").append(String.valueOf(this.paymentOptions));
        sb.append(", paymentGateway=").append(String.valueOf((Object)this.paymentGateway));
        sb.append(", billingAddress=").append(String.valueOf((Object)this.billingAddress));
        sb.append(", timePlanUpgrade=").append(String.valueOf(this.timePlanUpgrade));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionSummary)) {
            return false;
        }
        SubscriptionSummary other = (SubscriptionSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.subscriptionPlanNumber, other.subscriptionPlanNumber) && Objects.equals((Object)this.planType, (Object)other.planType) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.shipToCustAcctSiteId, other.shipToCustAcctSiteId) && Objects.equals(this.shipToCustAcctRoleId, other.shipToCustAcctRoleId) && Objects.equals(this.billToCustAccountId, other.billToCustAccountId) && Objects.equals(this.isIntentToPay, other.isIntentToPay) && Objects.equals(this.currencyCode, other.currencyCode) && Objects.equals(this.gsiOrgCode, other.gsiOrgCode) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.organizationId, other.organizationId) && Objects.equals((Object)this.upgradeState, (Object)other.upgradeState) && Objects.equals((Object)this.upgradeStateDetails, (Object)other.upgradeStateDetails) && Objects.equals((Object)this.taxInfo, (Object)other.taxInfo) && Objects.equals(this.paymentOptions, other.paymentOptions) && Objects.equals((Object)this.paymentGateway, (Object)other.paymentGateway) && Objects.equals((Object)this.billingAddress, (Object)other.billingAddress) && Objects.equals(this.timePlanUpgrade, other.timePlanUpgrade) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.subscriptionPlanNumber == null ? 43 : this.subscriptionPlanNumber.hashCode());
        result = result * 59 + (this.planType == null ? 43 : this.planType.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.shipToCustAcctSiteId == null ? 43 : this.shipToCustAcctSiteId.hashCode());
        result = result * 59 + (this.shipToCustAcctRoleId == null ? 43 : this.shipToCustAcctRoleId.hashCode());
        result = result * 59 + (this.billToCustAccountId == null ? 43 : this.billToCustAccountId.hashCode());
        result = result * 59 + (this.isIntentToPay == null ? 43 : this.isIntentToPay.hashCode());
        result = result * 59 + (this.currencyCode == null ? 43 : this.currencyCode.hashCode());
        result = result * 59 + (this.gsiOrgCode == null ? 43 : this.gsiOrgCode.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + (this.organizationId == null ? 43 : this.organizationId.hashCode());
        result = result * 59 + (this.upgradeState == null ? 43 : this.upgradeState.hashCode());
        result = result * 59 + (this.upgradeStateDetails == null ? 43 : this.upgradeStateDetails.hashCode());
        result = result * 59 + (this.taxInfo == null ? 43 : this.taxInfo.hashCode());
        result = result * 59 + (this.paymentOptions == null ? 43 : this.paymentOptions.hashCode());
        result = result * 59 + (this.paymentGateway == null ? 43 : this.paymentGateway.hashCode());
        result = result * 59 + (this.billingAddress == null ? 43 : this.billingAddress.hashCode());
        result = result * 59 + (this.timePlanUpgrade == null ? 43 : this.timePlanUpgrade.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UpgradeStateDetails implements BmcEnum
    {
        TaxError("TAX_ERROR"),
        UpgradeError("UPGRADE_ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UpgradeStateDetails> map;

        private UpgradeStateDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpgradeStateDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UpgradeStateDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UpgradeStateDetails.class);
            map = new HashMap<String, UpgradeStateDetails>();
            for (UpgradeStateDetails v : UpgradeStateDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UpgradeState implements BmcEnum
    {
        Promo("PROMO"),
        Submitted("SUBMITTED"),
        Error("ERROR"),
        Upgraded("UPGRADED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UpgradeState> map;

        private UpgradeState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpgradeState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UpgradeState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UpgradeState.class);
            map = new HashMap<String, UpgradeState>();
            for (UpgradeState v : UpgradeState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PlanType implements BmcEnum
    {
        FreeTier("FREE_TIER"),
        Payg("PAYG"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlanType> map;

        private PlanType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlanType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlanType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlanType.class);
            map = new HashMap<String, PlanType>();
            for (PlanType v : PlanType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="subscriptionPlanNumber")
        private String subscriptionPlanNumber;
        @JsonProperty(value="planType")
        private PlanType planType;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="shipToCustAcctSiteId")
        private String shipToCustAcctSiteId;
        @JsonProperty(value="shipToCustAcctRoleId")
        private String shipToCustAcctRoleId;
        @JsonProperty(value="billToCustAccountId")
        private String billToCustAccountId;
        @JsonProperty(value="isIntentToPay")
        private Boolean isIntentToPay;
        @JsonProperty(value="currencyCode")
        private String currencyCode;
        @JsonProperty(value="gsiOrgCode")
        private String gsiOrgCode;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonProperty(value="organizationId")
        private String organizationId;
        @JsonProperty(value="upgradeState")
        private UpgradeState upgradeState;
        @JsonProperty(value="upgradeStateDetails")
        private UpgradeStateDetails upgradeStateDetails;
        @JsonProperty(value="taxInfo")
        private TaxInfo taxInfo;
        @JsonProperty(value="paymentOptions")
        private List<PaymentOption> paymentOptions;
        @JsonProperty(value="paymentGateway")
        private PaymentGateway paymentGateway;
        @JsonProperty(value="billingAddress")
        private BillingAddress billingAddress;
        @JsonProperty(value="timePlanUpgrade")
        private Date timePlanUpgrade;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder subscriptionPlanNumber(String subscriptionPlanNumber) {
            this.subscriptionPlanNumber = subscriptionPlanNumber;
            this.__explicitlySet__.add("subscriptionPlanNumber");
            return this;
        }

        public Builder planType(PlanType planType) {
            this.planType = planType;
            this.__explicitlySet__.add("planType");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder shipToCustAcctSiteId(String shipToCustAcctSiteId) {
            this.shipToCustAcctSiteId = shipToCustAcctSiteId;
            this.__explicitlySet__.add("shipToCustAcctSiteId");
            return this;
        }

        public Builder shipToCustAcctRoleId(String shipToCustAcctRoleId) {
            this.shipToCustAcctRoleId = shipToCustAcctRoleId;
            this.__explicitlySet__.add("shipToCustAcctRoleId");
            return this;
        }

        public Builder billToCustAccountId(String billToCustAccountId) {
            this.billToCustAccountId = billToCustAccountId;
            this.__explicitlySet__.add("billToCustAccountId");
            return this;
        }

        public Builder isIntentToPay(Boolean isIntentToPay) {
            this.isIntentToPay = isIntentToPay;
            this.__explicitlySet__.add("isIntentToPay");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.__explicitlySet__.add("currencyCode");
            return this;
        }

        public Builder gsiOrgCode(String gsiOrgCode) {
            this.gsiOrgCode = gsiOrgCode;
            this.__explicitlySet__.add("gsiOrgCode");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            this.__explicitlySet__.add("organizationId");
            return this;
        }

        public Builder upgradeState(UpgradeState upgradeState) {
            this.upgradeState = upgradeState;
            this.__explicitlySet__.add("upgradeState");
            return this;
        }

        public Builder upgradeStateDetails(UpgradeStateDetails upgradeStateDetails) {
            this.upgradeStateDetails = upgradeStateDetails;
            this.__explicitlySet__.add("upgradeStateDetails");
            return this;
        }

        public Builder taxInfo(TaxInfo taxInfo) {
            this.taxInfo = taxInfo;
            this.__explicitlySet__.add("taxInfo");
            return this;
        }

        public Builder paymentOptions(List<PaymentOption> paymentOptions) {
            this.paymentOptions = paymentOptions;
            this.__explicitlySet__.add("paymentOptions");
            return this;
        }

        public Builder paymentGateway(PaymentGateway paymentGateway) {
            this.paymentGateway = paymentGateway;
            this.__explicitlySet__.add("paymentGateway");
            return this;
        }

        public Builder billingAddress(BillingAddress billingAddress) {
            this.billingAddress = billingAddress;
            this.__explicitlySet__.add("billingAddress");
            return this;
        }

        public Builder timePlanUpgrade(Date timePlanUpgrade) {
            this.timePlanUpgrade = timePlanUpgrade;
            this.__explicitlySet__.add("timePlanUpgrade");
            return this;
        }

        public SubscriptionSummary build() {
            SubscriptionSummary model = new SubscriptionSummary(this.id, this.subscriptionPlanNumber, this.planType, this.timeStart, this.shipToCustAcctSiteId, this.shipToCustAcctRoleId, this.billToCustAccountId, this.isIntentToPay, this.currencyCode, this.gsiOrgCode, this.languageCode, this.organizationId, this.upgradeState, this.upgradeStateDetails, this.taxInfo, this.paymentOptions, this.paymentGateway, this.billingAddress, this.timePlanUpgrade);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscriptionSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("subscriptionPlanNumber")) {
                this.subscriptionPlanNumber(model.getSubscriptionPlanNumber());
            }
            if (model.wasPropertyExplicitlySet("planType")) {
                this.planType(model.getPlanType());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("shipToCustAcctSiteId")) {
                this.shipToCustAcctSiteId(model.getShipToCustAcctSiteId());
            }
            if (model.wasPropertyExplicitlySet("shipToCustAcctRoleId")) {
                this.shipToCustAcctRoleId(model.getShipToCustAcctRoleId());
            }
            if (model.wasPropertyExplicitlySet("billToCustAccountId")) {
                this.billToCustAccountId(model.getBillToCustAccountId());
            }
            if (model.wasPropertyExplicitlySet("isIntentToPay")) {
                this.isIntentToPay(model.getIsIntentToPay());
            }
            if (model.wasPropertyExplicitlySet("currencyCode")) {
                this.currencyCode(model.getCurrencyCode());
            }
            if (model.wasPropertyExplicitlySet("gsiOrgCode")) {
                this.gsiOrgCode(model.getGsiOrgCode());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("organizationId")) {
                this.organizationId(model.getOrganizationId());
            }
            if (model.wasPropertyExplicitlySet("upgradeState")) {
                this.upgradeState(model.getUpgradeState());
            }
            if (model.wasPropertyExplicitlySet("upgradeStateDetails")) {
                this.upgradeStateDetails(model.getUpgradeStateDetails());
            }
            if (model.wasPropertyExplicitlySet("taxInfo")) {
                this.taxInfo(model.getTaxInfo());
            }
            if (model.wasPropertyExplicitlySet("paymentOptions")) {
                this.paymentOptions(model.getPaymentOptions());
            }
            if (model.wasPropertyExplicitlySet("paymentGateway")) {
                this.paymentGateway(model.getPaymentGateway());
            }
            if (model.wasPropertyExplicitlySet("billingAddress")) {
                this.billingAddress(model.getBillingAddress());
            }
            if (model.wasPropertyExplicitlySet("timePlanUpgrade")) {
                this.timePlanUpgrade(model.getTimePlanUpgrade());
            }
            return this;
        }
    }
}

