/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.CreditCardPaymentDetail;
import com.oracle.bmc.ospgateway.model.OtherPaymentDetail;
import com.oracle.bmc.ospgateway.model.PaypalPaymentDetail;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod", defaultImpl=PaymentDetail.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OtherPaymentDetail.class, name="OTHER"), @JsonSubTypes.Type(value=PaypalPaymentDetail.class, name="PAYPAL"), @JsonSubTypes.Type(value=CreditCardPaymentDetail.class, name="CREDIT_CARD")})
@JsonFilter(value="explicitlySetFilter")
public class PaymentDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timePaidOn")
    private final Date timePaidOn;
    @JsonProperty(value="paidBy")
    private final String paidBy;
    @JsonProperty(value="amountPaid")
    private final BigDecimal amountPaid;

    @Deprecated
    @ConstructorProperties(value={"timePaidOn", "paidBy", "amountPaid"})
    protected PaymentDetail(Date timePaidOn, String paidBy, BigDecimal amountPaid) {
        this.timePaidOn = timePaidOn;
        this.paidBy = paidBy;
        this.amountPaid = amountPaid;
    }

    public Date getTimePaidOn() {
        return this.timePaidOn;
    }

    public String getPaidBy() {
        return this.paidBy;
    }

    public BigDecimal getAmountPaid() {
        return this.amountPaid;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PaymentDetail(");
        sb.append("super=").append(super.toString());
        sb.append("timePaidOn=").append(String.valueOf(this.timePaidOn));
        sb.append(", paidBy=").append(String.valueOf(this.paidBy));
        sb.append(", amountPaid=").append(String.valueOf(this.amountPaid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaymentDetail)) {
            return false;
        }
        PaymentDetail other = (PaymentDetail)((Object)o);
        return Objects.equals(this.timePaidOn, other.timePaidOn) && Objects.equals(this.paidBy, other.paidBy) && Objects.equals(this.amountPaid, other.amountPaid) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timePaidOn == null ? 43 : this.timePaidOn.hashCode());
        result = result * 59 + (this.paidBy == null ? 43 : this.paidBy.hashCode());
        result = result * 59 + (this.amountPaid == null ? 43 : this.amountPaid.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PaymentMethod implements BmcEnum
    {
        CreditCard("CREDIT_CARD"),
        Paypal("PAYPAL"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PaymentMethod> map;

        private PaymentMethod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PaymentMethod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PaymentMethod', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PaymentMethod.class);
            map = new HashMap<String, PaymentMethod>();
            for (PaymentMethod v : PaymentMethod.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

