/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ospgateway.SubscriptionService;
import com.oracle.bmc.ospgateway.SubscriptionServiceAsyncClient;
import com.oracle.bmc.ospgateway.SubscriptionServicePaginators;
import com.oracle.bmc.ospgateway.model.AuthorizeSubscriptionPaymentReceipt;
import com.oracle.bmc.ospgateway.model.PaySubscriptionReceipt;
import com.oracle.bmc.ospgateway.model.Subscription;
import com.oracle.bmc.ospgateway.model.SubscriptionCollection;
import com.oracle.bmc.ospgateway.requests.AuthorizeSubscriptionPaymentRequest;
import com.oracle.bmc.ospgateway.requests.GetSubscriptionRequest;
import com.oracle.bmc.ospgateway.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ospgateway.requests.PaySubscriptionRequest;
import com.oracle.bmc.ospgateway.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ospgateway.responses.AuthorizeSubscriptionPaymentResponse;
import com.oracle.bmc.ospgateway.responses.GetSubscriptionResponse;
import com.oracle.bmc.ospgateway.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ospgateway.responses.PaySubscriptionResponse;
import com.oracle.bmc.ospgateway.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionServiceClient
extends BaseSyncClient
implements SubscriptionService {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SUBSCRIPTIONSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://ospap.oracle.com").build();
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionServiceAsyncClient.class);
    private final SubscriptionServicePaginators paginators = new SubscriptionServicePaginators(this);

    private SubscriptionServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AuthorizeSubscriptionPaymentResponse authorizeSubscriptionPayment(AuthorizeSubscriptionPaymentRequest request) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getAuthorizeSubscriptionPaymentDetails(), "authorizeSubscriptionPaymentDetails is required");
        return (AuthorizeSubscriptionPaymentResponse)this.clientCall(request, AuthorizeSubscriptionPaymentResponse::builder).logger(LOG, "authorizeSubscriptionPayment").serviceDetails("SubscriptionService", "AuthorizeSubscriptionPayment", "").method(Method.POST).requestBuilder(AuthorizeSubscriptionPaymentRequest::builder).basePath("/20191001").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("actions").appendPathParam("psd2auth").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AuthorizeSubscriptionPaymentReceipt.class, AuthorizeSubscriptionPaymentResponse.Builder::authorizeSubscriptionPaymentReceipt).handleResponseHeaderString("opc-request-id", AuthorizeSubscriptionPaymentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AuthorizeSubscriptionPaymentResponse.Builder::etag).callSync();
    }

    @Override
    public GetSubscriptionResponse getSubscription(GetSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetSubscriptionResponse)this.clientCall(request, GetSubscriptionResponse::builder).logger(LOG, "getSubscription").serviceDetails("SubscriptionService", "GetSubscription", "").method(Method.GET).requestBuilder(GetSubscriptionRequest::builder).basePath("/20191001").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscription.class, GetSubscriptionResponse.Builder::subscription).handleResponseHeaderString("etag", GetSubscriptionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSubscriptionsResponse)this.clientCall(request, ListSubscriptionsResponse::builder).logger(LOG, "listSubscriptions").serviceDetails("SubscriptionService", "ListSubscriptions", "").method(Method.GET).requestBuilder(ListSubscriptionsRequest::builder).basePath("/20191001").appendPathParam("subscriptions").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionCollection.class, ListSubscriptionsResponse.Builder::subscriptionCollection).handleResponseHeaderString("opc-request-id", ListSubscriptionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListSubscriptionsResponse.Builder::opcTotalItems).callSync();
    }

    @Override
    public PaySubscriptionResponse paySubscription(PaySubscriptionRequest request) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getPaySubscriptionDetails(), "paySubscriptionDetails is required");
        return (PaySubscriptionResponse)this.clientCall(request, PaySubscriptionResponse::builder).logger(LOG, "paySubscription").serviceDetails("SubscriptionService", "PaySubscription", "").method(Method.POST).requestBuilder(PaySubscriptionRequest::builder).basePath("/20191001").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("actions").appendPathParam("pay").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PaySubscriptionReceipt.class, PaySubscriptionResponse.Builder::paySubscriptionReceipt).handleResponseHeaderString("opc-request-id", PaySubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PaySubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateSubscriptionDetails(), "updateSubscriptionDetails is required");
        return (UpdateSubscriptionResponse)this.clientCall(request, UpdateSubscriptionResponse::builder).logger(LOG, "updateSubscription").serviceDetails("SubscriptionService", "UpdateSubscription", "").method(Method.PUT).requestBuilder(UpdateSubscriptionRequest::builder).basePath("/20191001").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Subscription.class, UpdateSubscriptionResponse.Builder::subscription).handleResponseHeaderString("etag", UpdateSubscriptionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SubscriptionServicePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SubscriptionServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SubscriptionServiceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SubscriptionServiceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SubscriptionServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SubscriptionServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SubscriptionServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SubscriptionServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscriptionServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SubscriptionServiceClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SubscriptionServiceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SubscriptionServiceClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

