/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ospgateway.InvoiceServiceAsync;
import com.oracle.bmc.ospgateway.model.Invoice;
import com.oracle.bmc.ospgateway.model.InvoiceCollection;
import com.oracle.bmc.ospgateway.model.InvoiceLineCollection;
import com.oracle.bmc.ospgateway.model.PayInvoiceReceipt;
import com.oracle.bmc.ospgateway.requests.DownloadPdfContentRequest;
import com.oracle.bmc.ospgateway.requests.GetInvoiceRequest;
import com.oracle.bmc.ospgateway.requests.ListInvoiceLinesRequest;
import com.oracle.bmc.ospgateway.requests.ListInvoicesRequest;
import com.oracle.bmc.ospgateway.requests.PayInvoiceRequest;
import com.oracle.bmc.ospgateway.responses.DownloadPdfContentResponse;
import com.oracle.bmc.ospgateway.responses.GetInvoiceResponse;
import com.oracle.bmc.ospgateway.responses.ListInvoiceLinesResponse;
import com.oracle.bmc.ospgateway.responses.ListInvoicesResponse;
import com.oracle.bmc.ospgateway.responses.PayInvoiceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceServiceAsyncClient
extends BaseAsyncClient
implements InvoiceServiceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INVOICESERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://ospap.oracle.com").build();
    private static final Logger LOG = LoggerFactory.getLogger(InvoiceServiceAsyncClient.class);

    private InvoiceServiceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<DownloadPdfContentResponse> downloadPdfContent(DownloadPdfContentRequest request, AsyncHandler<DownloadPdfContentRequest, DownloadPdfContentResponse> handler) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getInternalInvoiceId(), (String)"internalInvoiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DownloadPdfContentResponse::builder).logger(LOG, "downloadPdfContent").serviceDetails("InvoiceService", "DownloadPdfContent", "").method(Method.POST).requestBuilder(DownloadPdfContentRequest::builder).basePath("/20191001").appendPathParam("invoices").appendPathParam(request.getInternalInvoiceId()).appendPathParam("actions").appendPathParam("downloadPdfContent").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/pdf"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, DownloadPdfContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", DownloadPdfContentResponse.Builder::opcRequestId).handleResponseHeaderString("Content-Disposition", DownloadPdfContentResponse.Builder::contentDisposition).handleResponseHeaderString("Content-Type", DownloadPdfContentResponse.Builder::contentType).handleResponseHeaderInteger("Content-Length", DownloadPdfContentResponse.Builder::contentLength).callAsync(handler);
    }

    @Override
    public Future<GetInvoiceResponse> getInvoice(GetInvoiceRequest request, AsyncHandler<GetInvoiceRequest, GetInvoiceResponse> handler) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getInternalInvoiceId(), (String)"internalInvoiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInvoiceResponse::builder).logger(LOG, "getInvoice").serviceDetails("InvoiceService", "GetInvoice", "").method(Method.GET).requestBuilder(GetInvoiceRequest::builder).basePath("/20191001").appendPathParam("invoices").appendPathParam(request.getInternalInvoiceId()).appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Invoice.class, GetInvoiceResponse.Builder::invoice).handleResponseHeaderString("etag", GetInvoiceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInvoiceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInvoiceLinesResponse> listInvoiceLines(ListInvoiceLinesRequest request, AsyncHandler<ListInvoiceLinesRequest, ListInvoiceLinesResponse> handler) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getInternalInvoiceId(), (String)"internalInvoiceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListInvoiceLinesResponse::builder).logger(LOG, "listInvoiceLines").serviceDetails("InvoiceService", "ListInvoiceLines", "").method(Method.GET).requestBuilder(ListInvoiceLinesRequest::builder).basePath("/20191001").appendPathParam("invoices").appendPathParam(request.getInternalInvoiceId()).appendPathParam("invoiceLines").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InvoiceLineCollection.class, ListInvoiceLinesResponse.Builder::invoiceLineCollection).handleResponseHeaderString("etag", ListInvoiceLinesResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListInvoiceLinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInvoiceLinesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListInvoiceLinesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<ListInvoicesResponse> listInvoices(ListInvoicesRequest request, AsyncHandler<ListInvoicesRequest, ListInvoicesResponse> handler) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInvoicesResponse::builder).logger(LOG, "listInvoices").serviceDetails("InvoiceService", "ListInvoices", "").method(Method.GET).requestBuilder(ListInvoicesRequest::builder).basePath("/20191001").appendPathParam("invoices").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("invoiceId", (Object)request.getInvoiceId()).appendListQueryParam("type", request.getType(), CollectionFormatType.Multi).appendQueryParam("searchText", (Object)request.getSearchText()).appendQueryParam("timeInvoiceStart", (Object)request.getTimeInvoiceStart()).appendQueryParam("timeInvoiceEnd", (Object)request.getTimeInvoiceEnd()).appendQueryParam("timePaymentStart", (Object)request.getTimePaymentStart()).appendQueryParam("timePaymentEnd", (Object)request.getTimePaymentEnd()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InvoiceCollection.class, ListInvoicesResponse.Builder::invoiceCollection).handleResponseHeaderString("opc-request-id", ListInvoicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInvoicesResponse.Builder::opcNextPage).handleResponseHeaderInteger("opc-total-items", ListInvoicesResponse.Builder::opcTotalItems).callAsync(handler);
    }

    @Override
    public Future<PayInvoiceResponse> payInvoice(PayInvoiceRequest request, AsyncHandler<PayInvoiceRequest, PayInvoiceResponse> handler) {
        Objects.requireNonNull(request.getOspHomeRegion(), "ospHomeRegion is required");
        Validate.notBlank((String)request.getInternalInvoiceId(), (String)"internalInvoiceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getPayInvoiceDetails(), "payInvoiceDetails is required");
        return this.clientCall(request, PayInvoiceResponse::builder).logger(LOG, "payInvoice").serviceDetails("InvoiceService", "PayInvoice", "").method(Method.POST).requestBuilder(PayInvoiceRequest::builder).basePath("/20191001").appendPathParam("invoices").appendPathParam(request.getInternalInvoiceId()).appendPathParam("actions").appendPathParam("pay").appendQueryParam("ospHomeRegion", (Object)request.getOspHomeRegion()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PayInvoiceReceipt.class, PayInvoiceResponse.Builder::payInvoiceReceipt).handleResponseHeaderString("opc-request-id", PayInvoiceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PayInvoiceResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)InvoiceServiceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(InvoiceServiceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)InvoiceServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)InvoiceServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)InvoiceServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)InvoiceServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InvoiceServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, InvoiceServiceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public InvoiceServiceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new InvoiceServiceAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

