/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.osmanagement.model.RemovePackagesFromSoftwareSourceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemovePackagesFromSoftwareSourceRequest
extends BmcRequest<RemovePackagesFromSoftwareSourceDetails> {
    private String softwareSourceId;
    private RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails;
    private String opcRequestId;

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public RemovePackagesFromSoftwareSourceDetails getRemovePackagesFromSoftwareSourceDetails() {
        return this.removePackagesFromSoftwareSourceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RemovePackagesFromSoftwareSourceDetails getBody$() {
        return this.removePackagesFromSoftwareSourceDetails;
    }

    public Builder toBuilder() {
        return new Builder().softwareSourceId(this.softwareSourceId).removePackagesFromSoftwareSourceDetails(this.removePackagesFromSoftwareSourceDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(",removePackagesFromSoftwareSourceDetails=").append(String.valueOf((Object)this.removePackagesFromSoftwareSourceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemovePackagesFromSoftwareSourceRequest)) {
            return false;
        }
        RemovePackagesFromSoftwareSourceRequest other = (RemovePackagesFromSoftwareSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals((Object)this.removePackagesFromSoftwareSourceDetails, (Object)other.removePackagesFromSoftwareSourceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.removePackagesFromSoftwareSourceDetails == null ? 43 : this.removePackagesFromSoftwareSourceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemovePackagesFromSoftwareSourceRequest, RemovePackagesFromSoftwareSourceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String softwareSourceId = null;
        private RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails = null;
        private String opcRequestId = null;

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder removePackagesFromSoftwareSourceDetails(RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails) {
            this.removePackagesFromSoftwareSourceDetails = removePackagesFromSoftwareSourceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemovePackagesFromSoftwareSourceRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.removePackagesFromSoftwareSourceDetails(o.getRemovePackagesFromSoftwareSourceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemovePackagesFromSoftwareSourceRequest build() {
            RemovePackagesFromSoftwareSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RemovePackagesFromSoftwareSourceDetails body) {
            this.removePackagesFromSoftwareSourceDetails(body);
            return this;
        }

        public RemovePackagesFromSoftwareSourceRequest buildWithoutInvocationCallback() {
            RemovePackagesFromSoftwareSourceRequest request = new RemovePackagesFromSoftwareSourceRequest();
            request.softwareSourceId = this.softwareSourceId;
            request.removePackagesFromSoftwareSourceDetails = this.removePackagesFromSoftwareSourceDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

