/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.SoftwareSourceId;
import com.oracle.bmc.osmanagement.model.UpdateTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AvailableUpdateSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="updateType")
    private final UpdateTypes updateType;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="installedVersion")
    private final String installedVersion;
    @JsonProperty(value="availableVersion")
    private final String availableVersion;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="errata")
    private final List<Id> errata;
    @JsonProperty(value="relatedCves")
    private final List<String> relatedCves;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceId> softwareSources;

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "updateType", "type", "installedVersion", "availableVersion", "architecture", "errata", "relatedCves", "softwareSources"})
    public AvailableUpdateSummary(String displayName, String name, UpdateTypes updateType, String type, String installedVersion, String availableVersion, String architecture, List<Id> errata, List<String> relatedCves, List<SoftwareSourceId> softwareSources) {
        this.displayName = displayName;
        this.name = name;
        this.updateType = updateType;
        this.type = type;
        this.installedVersion = installedVersion;
        this.availableVersion = availableVersion;
        this.architecture = architecture;
        this.errata = errata;
        this.relatedCves = relatedCves;
        this.softwareSources = softwareSources;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public UpdateTypes getUpdateType() {
        return this.updateType;
    }

    public String getType() {
        return this.type;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public String getAvailableVersion() {
        return this.availableVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public List<Id> getErrata() {
        return this.errata;
    }

    public List<String> getRelatedCves() {
        return this.relatedCves;
    }

    public List<SoftwareSourceId> getSoftwareSources() {
        return this.softwareSources;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AvailableUpdateSummary(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", installedVersion=").append(String.valueOf(this.installedVersion));
        sb.append(", availableVersion=").append(String.valueOf(this.availableVersion));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", errata=").append(String.valueOf(this.errata));
        sb.append(", relatedCves=").append(String.valueOf(this.relatedCves));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvailableUpdateSummary)) {
            return false;
        }
        AvailableUpdateSummary other = (AvailableUpdateSummary)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.type, other.type) && Objects.equals(this.installedVersion, other.installedVersion) && Objects.equals(this.availableVersion, other.availableVersion) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.errata, other.errata) && Objects.equals(this.relatedCves, other.relatedCves) && Objects.equals(this.softwareSources, other.softwareSources) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.installedVersion == null ? 43 : this.installedVersion.hashCode());
        result = result * 59 + (this.availableVersion == null ? 43 : this.availableVersion.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.errata == null ? 43 : this.errata.hashCode());
        result = result * 59 + (this.relatedCves == null ? 43 : this.relatedCves.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="updateType")
        private UpdateTypes updateType;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="installedVersion")
        private String installedVersion;
        @JsonProperty(value="availableVersion")
        private String availableVersion;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="errata")
        private List<Id> errata;
        @JsonProperty(value="relatedCves")
        private List<String> relatedCves;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceId> softwareSources;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder updateType(UpdateTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            this.__explicitlySet__.add("installedVersion");
            return this;
        }

        public Builder availableVersion(String availableVersion) {
            this.availableVersion = availableVersion;
            this.__explicitlySet__.add("availableVersion");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder errata(List<Id> errata) {
            this.errata = errata;
            this.__explicitlySet__.add("errata");
            return this;
        }

        public Builder relatedCves(List<String> relatedCves) {
            this.relatedCves = relatedCves;
            this.__explicitlySet__.add("relatedCves");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceId> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public AvailableUpdateSummary build() {
            AvailableUpdateSummary model = new AvailableUpdateSummary(this.displayName, this.name, this.updateType, this.type, this.installedVersion, this.availableVersion, this.architecture, this.errata, this.relatedCves, this.softwareSources);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AvailableUpdateSummary model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("updateType")) {
                this.updateType(model.getUpdateType());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("installedVersion")) {
                this.installedVersion(model.getInstalledVersion());
            }
            if (model.wasPropertyExplicitlySet("availableVersion")) {
                this.availableVersion(model.getAvailableVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("errata")) {
                this.errata(model.getErrata());
            }
            if (model.wasPropertyExplicitlySet("relatedCves")) {
                this.relatedCves(model.getRelatedCves());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            return this;
        }
    }
}

