/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.CrashEventSystemInformation;
import com.oracle.bmc.osmanagement.model.Event;
import com.oracle.bmc.osmanagement.model.EventContent;
import com.oracle.bmc.osmanagement.model.KernelVmCoreInformation;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="eventType")
@JsonFilter(value="explicitlySetFilter")
public final class KernelCrashEvent
extends Event {
    @JsonProperty(value="reason")
    private final String reason;
    @JsonProperty(value="timeFirstOccurred")
    private final Date timeFirstOccurred;
    @JsonProperty(value="vmcore")
    private final KernelVmCoreInformation vmcore;
    @JsonProperty(value="content")
    private final EventContent content;
    @JsonProperty(value="system")
    private final CrashEventSystemInformation system;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public KernelCrashEvent(String id, String instanceId, String compartmentId, String tenancyId, String summary, Date timestamp, String eventFingerprint, Integer count, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String reason, Date timeFirstOccurred, KernelVmCoreInformation vmcore, EventContent content, CrashEventSystemInformation system) {
        super(id, instanceId, compartmentId, tenancyId, summary, timestamp, eventFingerprint, count, freeformTags, definedTags, systemTags);
        this.reason = reason;
        this.timeFirstOccurred = timeFirstOccurred;
        this.vmcore = vmcore;
        this.content = content;
        this.system = system;
    }

    public String getReason() {
        return this.reason;
    }

    public Date getTimeFirstOccurred() {
        return this.timeFirstOccurred;
    }

    public KernelVmCoreInformation getVmcore() {
        return this.vmcore;
    }

    public EventContent getContent() {
        return this.content;
    }

    public CrashEventSystemInformation getSystem() {
        return this.system;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KernelCrashEvent(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", reason=").append(String.valueOf(this.reason));
        sb.append(", timeFirstOccurred=").append(String.valueOf(this.timeFirstOccurred));
        sb.append(", vmcore=").append(String.valueOf((Object)this.vmcore));
        sb.append(", content=").append(String.valueOf((Object)this.content));
        sb.append(", system=").append(String.valueOf((Object)this.system));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KernelCrashEvent)) {
            return false;
        }
        KernelCrashEvent other = (KernelCrashEvent)((Object)o);
        return Objects.equals(this.reason, other.reason) && Objects.equals(this.timeFirstOccurred, other.timeFirstOccurred) && Objects.equals((Object)this.vmcore, (Object)other.vmcore) && Objects.equals((Object)this.content, (Object)other.content) && Objects.equals((Object)this.system, (Object)other.system) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reason == null ? 43 : this.reason.hashCode());
        result = result * 59 + (this.timeFirstOccurred == null ? 43 : this.timeFirstOccurred.hashCode());
        result = result * 59 + (this.vmcore == null ? 43 : this.vmcore.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.system == null ? 43 : this.system.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="eventFingerprint")
        private String eventFingerprint;
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="reason")
        private String reason;
        @JsonProperty(value="timeFirstOccurred")
        private Date timeFirstOccurred;
        @JsonProperty(value="vmcore")
        private KernelVmCoreInformation vmcore;
        @JsonProperty(value="content")
        private EventContent content;
        @JsonProperty(value="system")
        private CrashEventSystemInformation system;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder eventFingerprint(String eventFingerprint) {
            this.eventFingerprint = eventFingerprint;
            this.__explicitlySet__.add("eventFingerprint");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.__explicitlySet__.add("reason");
            return this;
        }

        public Builder timeFirstOccurred(Date timeFirstOccurred) {
            this.timeFirstOccurred = timeFirstOccurred;
            this.__explicitlySet__.add("timeFirstOccurred");
            return this;
        }

        public Builder vmcore(KernelVmCoreInformation vmcore) {
            this.vmcore = vmcore;
            this.__explicitlySet__.add("vmcore");
            return this;
        }

        public Builder content(EventContent content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder system(CrashEventSystemInformation system) {
            this.system = system;
            this.__explicitlySet__.add("system");
            return this;
        }

        public KernelCrashEvent build() {
            KernelCrashEvent model = new KernelCrashEvent(this.id, this.instanceId, this.compartmentId, this.tenancyId, this.summary, this.timestamp, this.eventFingerprint, this.count, this.freeformTags, this.definedTags, this.systemTags, this.reason, this.timeFirstOccurred, this.vmcore, this.content, this.system);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KernelCrashEvent model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("eventFingerprint")) {
                this.eventFingerprint(model.getEventFingerprint());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("reason")) {
                this.reason(model.getReason());
            }
            if (model.wasPropertyExplicitlySet("timeFirstOccurred")) {
                this.timeFirstOccurred(model.getTimeFirstOccurred());
            }
            if (model.wasPropertyExplicitlySet("vmcore")) {
                this.vmcore(model.getVmcore());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("system")) {
                this.system(model.getSystem());
            }
            return this;
        }
    }
}

