/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.osmanagement.Event;
import com.oracle.bmc.osmanagement.EventAsyncClient;
import com.oracle.bmc.osmanagement.EventPaginators;
import com.oracle.bmc.osmanagement.internal.http.DeleteEventContentConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventContentConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventConverter;
import com.oracle.bmc.osmanagement.internal.http.GetEventReportConverter;
import com.oracle.bmc.osmanagement.internal.http.ListEventsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListRelatedEventsConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateEventConverter;
import com.oracle.bmc.osmanagement.internal.http.UploadEventContentConverter;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventClient
implements Event {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(EventAsyncClient.class);
    private final EventPaginators paginators;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    RestClient getClient() {
        return this.client;
    }

    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration userCircuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        this.circuitBreakerConfiguration = userCircuitBreakerConfiguration == null ? CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION : userCircuitBreakerConfiguration;
        this.refreshClient();
        this.paginators = new EventPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient, null, this.circuitBreakerConfiguration);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public DeleteEventContentResponse deleteEventContent(DeleteEventContentRequest request) {
        LOG.trace("Called deleteEventContent");
        DeleteEventContentRequest interceptedRequest = DeleteEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEventContentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "DeleteEventContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/DeleteEventContent");
        Function<Response, DeleteEventContentResponse> transformer = DeleteEventContentConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteEventContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteEventContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteEventContentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetEventResponse getEvent(GetEventRequest request) {
        LOG.trace("Called getEvent");
        GetEventRequest interceptedRequest = GetEventConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEvent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/GetEvent");
        Function<Response, GetEventResponse> transformer = GetEventConverter.fromResponse(Optional.of(serviceDetails));
        return (GetEventResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEventResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEventResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetEventContentResponse getEventContent(GetEventContentRequest request) {
        LOG.trace("Called getEventContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getEventContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetEventContentRequest interceptedRequest = GetEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventContentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEventContent", ib.getRequestUri().toString(), "");
        Function<Response, GetEventContentResponse> transformer = GetEventContentConverter.fromResponse(Optional.of(serviceDetails));
        return (GetEventContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEventContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEventContentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetEventReportResponse getEventReport(GetEventReportRequest request) {
        LOG.trace("Called getEventReport");
        GetEventReportRequest interceptedRequest = GetEventReportConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEventReportConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "GetEventReport", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventReport/GetEventReport");
        Function<Response, GetEventReportResponse> transformer = GetEventReportConverter.fromResponse(Optional.of(serviceDetails));
        return (GetEventReportResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEventReportResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEventReportResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListEventsResponse listEvents(ListEventsRequest request) {
        LOG.trace("Called listEvents");
        ListEventsRequest interceptedRequest = ListEventsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEventsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "ListEvents", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventCollection/ListEvents");
        Function<Response, ListEventsResponse> transformer = ListEventsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListEventsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEventsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEventsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListRelatedEventsResponse listRelatedEvents(ListRelatedEventsRequest request) {
        LOG.trace("Called listRelatedEvents");
        ListRelatedEventsRequest interceptedRequest = ListRelatedEventsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRelatedEventsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "ListRelatedEvents", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/RelatedEventCollection/ListRelatedEvents");
        Function<Response, ListRelatedEventsResponse> transformer = ListRelatedEventsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListRelatedEventsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRelatedEventsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRelatedEventsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateEventResponse updateEvent(UpdateEventRequest request) {
        LOG.trace("Called updateEvent");
        UpdateEventRequest interceptedRequest = UpdateEventConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEventConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "UpdateEvent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/UpdateEvent");
        Function<Response, UpdateEventResponse> transformer = UpdateEventConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateEventResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateEventResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateEventDetails(), (BmcRequest)retriedRequest);
                return (UpdateEventResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UploadEventContentResponse uploadEventContent(UploadEventContentRequest request) {
        LOG.trace("Called uploadEventContent");
        UploadEventContentRequest interceptedRequest = UploadEventContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadEventContentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("Event", "UploadEventContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/UploadEventContent");
        Function<Response, UploadEventContentResponse> transformer = UploadEventContentConverter.fromResponse(Optional.of(serviceDetails));
        return (UploadEventContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UploadEventContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (UploadEventContentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public EventPaginators getPaginators() {
        return this.paginators;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EventClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new EventClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

