/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.AutonomousSettings;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import com.oracle.bmc.osmanagement.model.SoftwareSourceId;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="lastCheckin")
    private final String lastCheckin;
    @JsonProperty(value="lastBoot")
    private final String lastBoot;
    @JsonProperty(value="updatesAvailable")
    private final Integer updatesAvailable;
    @JsonProperty(value="osName")
    private final String osName;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="osKernelVersion")
    private final String osKernelVersion;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="parentSoftwareSource")
    private final SoftwareSourceId parentSoftwareSource;
    @JsonProperty(value="childSoftwareSources")
    private final List<SoftwareSourceId> childSoftwareSources;
    @JsonProperty(value="managedInstanceGroups")
    private final List<Id> managedInstanceGroups;
    @JsonProperty(value="osFamily")
    private final OsFamilies osFamily;
    @JsonProperty(value="isRebootRequired")
    private final Boolean isRebootRequired;
    @JsonProperty(value="notificationTopicId")
    private final String notificationTopicId;
    @JsonProperty(value="kspliceEffectiveKernelVersion")
    private final String kspliceEffectiveKernelVersion;
    @JsonProperty(value="isDataCollectionAuthorized")
    private final Boolean isDataCollectionAuthorized;
    @JsonProperty(value="autonomous")
    private final AutonomousSettings autonomous;
    @JsonProperty(value="securityUpdatesAvailable")
    private final Integer securityUpdatesAvailable;
    @JsonProperty(value="bugUpdatesAvailable")
    private final Integer bugUpdatesAvailable;
    @JsonProperty(value="enhancementUpdatesAvailable")
    private final Integer enhancementUpdatesAvailable;
    @JsonProperty(value="otherUpdatesAvailable")
    private final Integer otherUpdatesAvailable;
    @JsonProperty(value="scheduledJobCount")
    private final Integer scheduledJobCount;
    @JsonProperty(value="workRequestCount")
    private final Integer workRequestCount;

    @Deprecated
    @ConstructorProperties(value={"displayName", "id", "description", "lastCheckin", "lastBoot", "updatesAvailable", "osName", "osVersion", "osKernelVersion", "compartmentId", "status", "parentSoftwareSource", "childSoftwareSources", "managedInstanceGroups", "osFamily", "isRebootRequired", "notificationTopicId", "kspliceEffectiveKernelVersion", "isDataCollectionAuthorized", "autonomous", "securityUpdatesAvailable", "bugUpdatesAvailable", "enhancementUpdatesAvailable", "otherUpdatesAvailable", "scheduledJobCount", "workRequestCount"})
    public ManagedInstance(String displayName, String id, String description, String lastCheckin, String lastBoot, Integer updatesAvailable, String osName, String osVersion, String osKernelVersion, String compartmentId, Status status, SoftwareSourceId parentSoftwareSource, List<SoftwareSourceId> childSoftwareSources, List<Id> managedInstanceGroups, OsFamilies osFamily, Boolean isRebootRequired, String notificationTopicId, String kspliceEffectiveKernelVersion, Boolean isDataCollectionAuthorized, AutonomousSettings autonomous, Integer securityUpdatesAvailable, Integer bugUpdatesAvailable, Integer enhancementUpdatesAvailable, Integer otherUpdatesAvailable, Integer scheduledJobCount, Integer workRequestCount) {
        this.displayName = displayName;
        this.id = id;
        this.description = description;
        this.lastCheckin = lastCheckin;
        this.lastBoot = lastBoot;
        this.updatesAvailable = updatesAvailable;
        this.osName = osName;
        this.osVersion = osVersion;
        this.osKernelVersion = osKernelVersion;
        this.compartmentId = compartmentId;
        this.status = status;
        this.parentSoftwareSource = parentSoftwareSource;
        this.childSoftwareSources = childSoftwareSources;
        this.managedInstanceGroups = managedInstanceGroups;
        this.osFamily = osFamily;
        this.isRebootRequired = isRebootRequired;
        this.notificationTopicId = notificationTopicId;
        this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
        this.isDataCollectionAuthorized = isDataCollectionAuthorized;
        this.autonomous = autonomous;
        this.securityUpdatesAvailable = securityUpdatesAvailable;
        this.bugUpdatesAvailable = bugUpdatesAvailable;
        this.enhancementUpdatesAvailable = enhancementUpdatesAvailable;
        this.otherUpdatesAvailable = otherUpdatesAvailable;
        this.scheduledJobCount = scheduledJobCount;
        this.workRequestCount = workRequestCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLastCheckin() {
        return this.lastCheckin;
    }

    public String getLastBoot() {
        return this.lastBoot;
    }

    public Integer getUpdatesAvailable() {
        return this.updatesAvailable;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsKernelVersion() {
        return this.osKernelVersion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Status getStatus() {
        return this.status;
    }

    public SoftwareSourceId getParentSoftwareSource() {
        return this.parentSoftwareSource;
    }

    public List<SoftwareSourceId> getChildSoftwareSources() {
        return this.childSoftwareSources;
    }

    public List<Id> getManagedInstanceGroups() {
        return this.managedInstanceGroups;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public Boolean getIsRebootRequired() {
        return this.isRebootRequired;
    }

    public String getNotificationTopicId() {
        return this.notificationTopicId;
    }

    public String getKspliceEffectiveKernelVersion() {
        return this.kspliceEffectiveKernelVersion;
    }

    public Boolean getIsDataCollectionAuthorized() {
        return this.isDataCollectionAuthorized;
    }

    public AutonomousSettings getAutonomous() {
        return this.autonomous;
    }

    public Integer getSecurityUpdatesAvailable() {
        return this.securityUpdatesAvailable;
    }

    public Integer getBugUpdatesAvailable() {
        return this.bugUpdatesAvailable;
    }

    public Integer getEnhancementUpdatesAvailable() {
        return this.enhancementUpdatesAvailable;
    }

    public Integer getOtherUpdatesAvailable() {
        return this.otherUpdatesAvailable;
    }

    public Integer getScheduledJobCount() {
        return this.scheduledJobCount;
    }

    public Integer getWorkRequestCount() {
        return this.workRequestCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstance(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", lastCheckin=").append(String.valueOf(this.lastCheckin));
        sb.append(", lastBoot=").append(String.valueOf(this.lastBoot));
        sb.append(", updatesAvailable=").append(String.valueOf(this.updatesAvailable));
        sb.append(", osName=").append(String.valueOf(this.osName));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", osKernelVersion=").append(String.valueOf(this.osKernelVersion));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", parentSoftwareSource=").append(String.valueOf((Object)this.parentSoftwareSource));
        sb.append(", childSoftwareSources=").append(String.valueOf(this.childSoftwareSources));
        sb.append(", managedInstanceGroups=").append(String.valueOf(this.managedInstanceGroups));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", isRebootRequired=").append(String.valueOf(this.isRebootRequired));
        sb.append(", notificationTopicId=").append(String.valueOf(this.notificationTopicId));
        sb.append(", kspliceEffectiveKernelVersion=").append(String.valueOf(this.kspliceEffectiveKernelVersion));
        sb.append(", isDataCollectionAuthorized=").append(String.valueOf(this.isDataCollectionAuthorized));
        sb.append(", autonomous=").append(String.valueOf((Object)this.autonomous));
        sb.append(", securityUpdatesAvailable=").append(String.valueOf(this.securityUpdatesAvailable));
        sb.append(", bugUpdatesAvailable=").append(String.valueOf(this.bugUpdatesAvailable));
        sb.append(", enhancementUpdatesAvailable=").append(String.valueOf(this.enhancementUpdatesAvailable));
        sb.append(", otherUpdatesAvailable=").append(String.valueOf(this.otherUpdatesAvailable));
        sb.append(", scheduledJobCount=").append(String.valueOf(this.scheduledJobCount));
        sb.append(", workRequestCount=").append(String.valueOf(this.workRequestCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstance)) {
            return false;
        }
        ManagedInstance other = (ManagedInstance)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && Objects.equals(this.lastCheckin, other.lastCheckin) && Objects.equals(this.lastBoot, other.lastBoot) && Objects.equals(this.updatesAvailable, other.updatesAvailable) && Objects.equals(this.osName, other.osName) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.osKernelVersion, other.osKernelVersion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.parentSoftwareSource, (Object)other.parentSoftwareSource) && Objects.equals(this.childSoftwareSources, other.childSoftwareSources) && Objects.equals(this.managedInstanceGroups, other.managedInstanceGroups) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.isRebootRequired, other.isRebootRequired) && Objects.equals(this.notificationTopicId, other.notificationTopicId) && Objects.equals(this.kspliceEffectiveKernelVersion, other.kspliceEffectiveKernelVersion) && Objects.equals(this.isDataCollectionAuthorized, other.isDataCollectionAuthorized) && Objects.equals((Object)this.autonomous, (Object)other.autonomous) && Objects.equals(this.securityUpdatesAvailable, other.securityUpdatesAvailable) && Objects.equals(this.bugUpdatesAvailable, other.bugUpdatesAvailable) && Objects.equals(this.enhancementUpdatesAvailable, other.enhancementUpdatesAvailable) && Objects.equals(this.otherUpdatesAvailable, other.otherUpdatesAvailable) && Objects.equals(this.scheduledJobCount, other.scheduledJobCount) && Objects.equals(this.workRequestCount, other.workRequestCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.lastCheckin == null ? 43 : this.lastCheckin.hashCode());
        result = result * 59 + (this.lastBoot == null ? 43 : this.lastBoot.hashCode());
        result = result * 59 + (this.updatesAvailable == null ? 43 : this.updatesAvailable.hashCode());
        result = result * 59 + (this.osName == null ? 43 : this.osName.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.osKernelVersion == null ? 43 : this.osKernelVersion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.parentSoftwareSource == null ? 43 : this.parentSoftwareSource.hashCode());
        result = result * 59 + (this.childSoftwareSources == null ? 43 : this.childSoftwareSources.hashCode());
        result = result * 59 + (this.managedInstanceGroups == null ? 43 : this.managedInstanceGroups.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.isRebootRequired == null ? 43 : this.isRebootRequired.hashCode());
        result = result * 59 + (this.notificationTopicId == null ? 43 : this.notificationTopicId.hashCode());
        result = result * 59 + (this.kspliceEffectiveKernelVersion == null ? 43 : this.kspliceEffectiveKernelVersion.hashCode());
        result = result * 59 + (this.isDataCollectionAuthorized == null ? 43 : this.isDataCollectionAuthorized.hashCode());
        result = result * 59 + (this.autonomous == null ? 43 : this.autonomous.hashCode());
        result = result * 59 + (this.securityUpdatesAvailable == null ? 43 : this.securityUpdatesAvailable.hashCode());
        result = result * 59 + (this.bugUpdatesAvailable == null ? 43 : this.bugUpdatesAvailable.hashCode());
        result = result * 59 + (this.enhancementUpdatesAvailable == null ? 43 : this.enhancementUpdatesAvailable.hashCode());
        result = result * 59 + (this.otherUpdatesAvailable == null ? 43 : this.otherUpdatesAvailable.hashCode());
        result = result * 59 + (this.scheduledJobCount == null ? 43 : this.scheduledJobCount.hashCode());
        result = result * 59 + (this.workRequestCount == null ? 43 : this.workRequestCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status {
        Normal("NORMAL"),
        Unreachable("UNREACHABLE"),
        Error("ERROR"),
        Warning("WARNING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="lastCheckin")
        private String lastCheckin;
        @JsonProperty(value="lastBoot")
        private String lastBoot;
        @JsonProperty(value="updatesAvailable")
        private Integer updatesAvailable;
        @JsonProperty(value="osName")
        private String osName;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="osKernelVersion")
        private String osKernelVersion;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="parentSoftwareSource")
        private SoftwareSourceId parentSoftwareSource;
        @JsonProperty(value="childSoftwareSources")
        private List<SoftwareSourceId> childSoftwareSources;
        @JsonProperty(value="managedInstanceGroups")
        private List<Id> managedInstanceGroups;
        @JsonProperty(value="osFamily")
        private OsFamilies osFamily;
        @JsonProperty(value="isRebootRequired")
        private Boolean isRebootRequired;
        @JsonProperty(value="notificationTopicId")
        private String notificationTopicId;
        @JsonProperty(value="kspliceEffectiveKernelVersion")
        private String kspliceEffectiveKernelVersion;
        @JsonProperty(value="isDataCollectionAuthorized")
        private Boolean isDataCollectionAuthorized;
        @JsonProperty(value="autonomous")
        private AutonomousSettings autonomous;
        @JsonProperty(value="securityUpdatesAvailable")
        private Integer securityUpdatesAvailable;
        @JsonProperty(value="bugUpdatesAvailable")
        private Integer bugUpdatesAvailable;
        @JsonProperty(value="enhancementUpdatesAvailable")
        private Integer enhancementUpdatesAvailable;
        @JsonProperty(value="otherUpdatesAvailable")
        private Integer otherUpdatesAvailable;
        @JsonProperty(value="scheduledJobCount")
        private Integer scheduledJobCount;
        @JsonProperty(value="workRequestCount")
        private Integer workRequestCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder lastCheckin(String lastCheckin) {
            this.lastCheckin = lastCheckin;
            this.__explicitlySet__.add("lastCheckin");
            return this;
        }

        public Builder lastBoot(String lastBoot) {
            this.lastBoot = lastBoot;
            this.__explicitlySet__.add("lastBoot");
            return this;
        }

        public Builder updatesAvailable(Integer updatesAvailable) {
            this.updatesAvailable = updatesAvailable;
            this.__explicitlySet__.add("updatesAvailable");
            return this;
        }

        public Builder osName(String osName) {
            this.osName = osName;
            this.__explicitlySet__.add("osName");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder osKernelVersion(String osKernelVersion) {
            this.osKernelVersion = osKernelVersion;
            this.__explicitlySet__.add("osKernelVersion");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder parentSoftwareSource(SoftwareSourceId parentSoftwareSource) {
            this.parentSoftwareSource = parentSoftwareSource;
            this.__explicitlySet__.add("parentSoftwareSource");
            return this;
        }

        public Builder childSoftwareSources(List<SoftwareSourceId> childSoftwareSources) {
            this.childSoftwareSources = childSoftwareSources;
            this.__explicitlySet__.add("childSoftwareSources");
            return this;
        }

        public Builder managedInstanceGroups(List<Id> managedInstanceGroups) {
            this.managedInstanceGroups = managedInstanceGroups;
            this.__explicitlySet__.add("managedInstanceGroups");
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder isRebootRequired(Boolean isRebootRequired) {
            this.isRebootRequired = isRebootRequired;
            this.__explicitlySet__.add("isRebootRequired");
            return this;
        }

        public Builder notificationTopicId(String notificationTopicId) {
            this.notificationTopicId = notificationTopicId;
            this.__explicitlySet__.add("notificationTopicId");
            return this;
        }

        public Builder kspliceEffectiveKernelVersion(String kspliceEffectiveKernelVersion) {
            this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
            this.__explicitlySet__.add("kspliceEffectiveKernelVersion");
            return this;
        }

        public Builder isDataCollectionAuthorized(Boolean isDataCollectionAuthorized) {
            this.isDataCollectionAuthorized = isDataCollectionAuthorized;
            this.__explicitlySet__.add("isDataCollectionAuthorized");
            return this;
        }

        public Builder autonomous(AutonomousSettings autonomous) {
            this.autonomous = autonomous;
            this.__explicitlySet__.add("autonomous");
            return this;
        }

        public Builder securityUpdatesAvailable(Integer securityUpdatesAvailable) {
            this.securityUpdatesAvailable = securityUpdatesAvailable;
            this.__explicitlySet__.add("securityUpdatesAvailable");
            return this;
        }

        public Builder bugUpdatesAvailable(Integer bugUpdatesAvailable) {
            this.bugUpdatesAvailable = bugUpdatesAvailable;
            this.__explicitlySet__.add("bugUpdatesAvailable");
            return this;
        }

        public Builder enhancementUpdatesAvailable(Integer enhancementUpdatesAvailable) {
            this.enhancementUpdatesAvailable = enhancementUpdatesAvailable;
            this.__explicitlySet__.add("enhancementUpdatesAvailable");
            return this;
        }

        public Builder otherUpdatesAvailable(Integer otherUpdatesAvailable) {
            this.otherUpdatesAvailable = otherUpdatesAvailable;
            this.__explicitlySet__.add("otherUpdatesAvailable");
            return this;
        }

        public Builder scheduledJobCount(Integer scheduledJobCount) {
            this.scheduledJobCount = scheduledJobCount;
            this.__explicitlySet__.add("scheduledJobCount");
            return this;
        }

        public Builder workRequestCount(Integer workRequestCount) {
            this.workRequestCount = workRequestCount;
            this.__explicitlySet__.add("workRequestCount");
            return this;
        }

        public ManagedInstance build() {
            ManagedInstance model = new ManagedInstance(this.displayName, this.id, this.description, this.lastCheckin, this.lastBoot, this.updatesAvailable, this.osName, this.osVersion, this.osKernelVersion, this.compartmentId, this.status, this.parentSoftwareSource, this.childSoftwareSources, this.managedInstanceGroups, this.osFamily, this.isRebootRequired, this.notificationTopicId, this.kspliceEffectiveKernelVersion, this.isDataCollectionAuthorized, this.autonomous, this.securityUpdatesAvailable, this.bugUpdatesAvailable, this.enhancementUpdatesAvailable, this.otherUpdatesAvailable, this.scheduledJobCount, this.workRequestCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstance model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("lastCheckin")) {
                this.lastCheckin(model.getLastCheckin());
            }
            if (model.wasPropertyExplicitlySet("lastBoot")) {
                this.lastBoot(model.getLastBoot());
            }
            if (model.wasPropertyExplicitlySet("updatesAvailable")) {
                this.updatesAvailable(model.getUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("osName")) {
                this.osName(model.getOsName());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("osKernelVersion")) {
                this.osKernelVersion(model.getOsKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("parentSoftwareSource")) {
                this.parentSoftwareSource(model.getParentSoftwareSource());
            }
            if (model.wasPropertyExplicitlySet("childSoftwareSources")) {
                this.childSoftwareSources(model.getChildSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceGroups")) {
                this.managedInstanceGroups(model.getManagedInstanceGroups());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("isRebootRequired")) {
                this.isRebootRequired(model.getIsRebootRequired());
            }
            if (model.wasPropertyExplicitlySet("notificationTopicId")) {
                this.notificationTopicId(model.getNotificationTopicId());
            }
            if (model.wasPropertyExplicitlySet("kspliceEffectiveKernelVersion")) {
                this.kspliceEffectiveKernelVersion(model.getKspliceEffectiveKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("isDataCollectionAuthorized")) {
                this.isDataCollectionAuthorized(model.getIsDataCollectionAuthorized());
            }
            if (model.wasPropertyExplicitlySet("autonomous")) {
                this.autonomous(model.getAutonomous());
            }
            if (model.wasPropertyExplicitlySet("securityUpdatesAvailable")) {
                this.securityUpdatesAvailable(model.getSecurityUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("bugUpdatesAvailable")) {
                this.bugUpdatesAvailable(model.getBugUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("enhancementUpdatesAvailable")) {
                this.enhancementUpdatesAvailable(model.getEnhancementUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("otherUpdatesAvailable")) {
                this.otherUpdatesAvailable(model.getOtherUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("scheduledJobCount")) {
                this.scheduledJobCount(model.getScheduledJobCount());
            }
            if (model.wasPropertyExplicitlySet("workRequestCount")) {
                this.workRequestCount(model.getWorkRequestCount());
            }
            return this;
        }
    }
}

