/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Date;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class GetEventReportRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String compartmentId;
    private Date latestTimestampLessThan;
    private Date latestTimestampGreaterThanOrEqualTo;
    private String opcRequestId;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getLatestTimestampLessThan() {
        return this.latestTimestampLessThan;
    }

    public Date getLatestTimestampGreaterThanOrEqualTo() {
        return this.latestTimestampGreaterThanOrEqualTo;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).compartmentId(this.compartmentId).latestTimestampLessThan(this.latestTimestampLessThan).latestTimestampGreaterThanOrEqualTo(this.latestTimestampGreaterThanOrEqualTo).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",latestTimestampLessThan=").append(String.valueOf(this.latestTimestampLessThan));
        sb.append(",latestTimestampGreaterThanOrEqualTo=").append(String.valueOf(this.latestTimestampGreaterThanOrEqualTo));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEventReportRequest)) {
            return false;
        }
        GetEventReportRequest other = (GetEventReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.latestTimestampLessThan, other.latestTimestampLessThan) && Objects.equals(this.latestTimestampGreaterThanOrEqualTo, other.latestTimestampGreaterThanOrEqualTo) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.latestTimestampLessThan == null ? 43 : this.latestTimestampLessThan.hashCode());
        result = result * 59 + (this.latestTimestampGreaterThanOrEqualTo == null ? 43 : this.latestTimestampGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEventReportRequest, Void> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private String compartmentId = null;
        private Date latestTimestampLessThan = null;
        private Date latestTimestampGreaterThanOrEqualTo = null;
        private String opcRequestId = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder latestTimestampLessThan(Date latestTimestampLessThan) {
            this.latestTimestampLessThan = latestTimestampLessThan;
            return this;
        }

        public Builder latestTimestampGreaterThanOrEqualTo(Date latestTimestampGreaterThanOrEqualTo) {
            this.latestTimestampGreaterThanOrEqualTo = latestTimestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEventReportRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.compartmentId(o.getCompartmentId());
            this.latestTimestampLessThan(o.getLatestTimestampLessThan());
            this.latestTimestampGreaterThanOrEqualTo(o.getLatestTimestampGreaterThanOrEqualTo());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEventReportRequest build() {
            GetEventReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEventReportRequest buildWithoutInvocationCallback() {
            GetEventReportRequest request = new GetEventReportRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.compartmentId = this.compartmentId;
            request.latestTimestampLessThan = this.latestTimestampLessThan;
            request.latestTimestampGreaterThanOrEqualTo = this.latestTimestampGreaterThanOrEqualTo;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

