/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.WindowsUpdate;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetWindowsUpdateConverter {
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();
    private static final Logger LOG = LoggerFactory.getLogger(GetWindowsUpdateConverter.class);

    public static GetWindowsUpdateRequest interceptRequest(GetWindowsUpdateRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetWindowsUpdateRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWindowsUpdate(), (String)"windowsUpdate must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("updates").path(HttpUtils.encodePathSegment((String)request.getWindowsUpdate()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetWindowsUpdateResponse> fromResponse() {
        return GetWindowsUpdateConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetWindowsUpdateResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetWindowsUpdateResponse> transformer = new Function<Response, GetWindowsUpdateResponse>(){

            @Override
            public GetWindowsUpdateResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(WindowsUpdate.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(WindowsUpdate.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetWindowsUpdateResponse.Builder builder = GetWindowsUpdateResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.windowsUpdate((WindowsUpdate)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetWindowsUpdateResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

