/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ManagedInstanceGroup;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetManagedInstanceGroupConverter {
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();
    private static final Logger LOG = LoggerFactory.getLogger(GetManagedInstanceGroupConverter.class);

    public static GetManagedInstanceGroupRequest interceptRequest(GetManagedInstanceGroupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetManagedInstanceGroupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getManagedInstanceGroupId(), (String)"managedInstanceGroupId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("managedInstanceGroups").path(HttpUtils.encodePathSegment((String)request.getManagedInstanceGroupId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetManagedInstanceGroupResponse> fromResponse() {
        return GetManagedInstanceGroupConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetManagedInstanceGroupResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetManagedInstanceGroupResponse> transformer = new Function<Response, GetManagedInstanceGroupResponse>(){

            @Override
            public GetManagedInstanceGroupResponse apply(Response rawResponse) {
                Optional retryAfterHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(ManagedInstanceGroup.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(ManagedInstanceGroup.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetManagedInstanceGroupResponse.Builder builder = GetManagedInstanceGroupResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.managedInstanceGroup((ManagedInstanceGroup)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"retry-after")).isPresent()) {
                    builder.retryAfter((Float)HeaderUtils.toValue((String)"retry-after", (String)((String)((List)retryAfterHeader.get()).get(0)), Float.class));
                }
                GetManagedInstanceGroupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

