/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.OperationStatus;
import com.oracle.bmc.osmanagement.model.OperationTypes;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import com.oracle.bmc.osmanagement.model.WorkRequestResource;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequest {
    @JsonProperty(value="operationType")
    private final OperationTypes operationType;
    @JsonProperty(value="status")
    private final OperationStatus status;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="managedInstanceId")
    private final Id managedInstanceId;
    @JsonProperty(value="resources")
    private final List<WorkRequestResource> resources;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="osFamily")
    private final OsFamilies osFamily;
    @JsonProperty(value="parentId")
    private final String parentId;
    @JsonProperty(value="childrenIds")
    private final List<String> childrenIds;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    @Deprecated
    @ConstructorProperties(value={"operationType", "status", "id", "compartmentId", "description", "message", "managedInstanceId", "resources", "percentComplete", "timeAccepted", "timeStarted", "timeFinished", "osFamily", "parentId", "childrenIds"})
    public WorkRequest(OperationTypes operationType, OperationStatus status, String id, String compartmentId, String description, String message, Id managedInstanceId, List<WorkRequestResource> resources, Float percentComplete, Date timeAccepted, Date timeStarted, Date timeFinished, OsFamilies osFamily, String parentId, List<String> childrenIds) {
        this.operationType = operationType;
        this.status = status;
        this.id = id;
        this.compartmentId = compartmentId;
        this.description = description;
        this.message = message;
        this.managedInstanceId = managedInstanceId;
        this.resources = resources;
        this.percentComplete = percentComplete;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.osFamily = osFamily;
        this.parentId = parentId;
        this.childrenIds = childrenIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationTypes getOperationType() {
        return this.operationType;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessage() {
        return this.message;
    }

    public Id getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public List<WorkRequestResource> getResources() {
        return this.resources;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<String> getChildrenIds() {
        return this.childrenIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequest(");
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", parentId=").append(String.valueOf(this.parentId));
        sb.append(", childrenIds=").append(String.valueOf(this.childrenIds));
        sb.append("__explicitlySet__=").append(String.valueOf(this.__explicitlySet__));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequest)) {
            return false;
        }
        WorkRequest other = (WorkRequest)o;
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.message, other.message) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.resources, other.resources) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.childrenIds, other.childrenIds) && Objects.equals(this.__explicitlySet__, other.__explicitlySet__);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.childrenIds == null ? 43 : this.childrenIds.hashCode());
        result = result * 59 + (this.__explicitlySet__ == null ? 43 : this.__explicitlySet__.hashCode());
        return result;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationTypes operationType;
        @JsonProperty(value="status")
        private OperationStatus status;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="managedInstanceId")
        private Id managedInstanceId;
        @JsonProperty(value="resources")
        private List<WorkRequestResource> resources;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="osFamily")
        private OsFamilies osFamily;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="childrenIds")
        private List<String> childrenIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationTypes operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder managedInstanceId(Id managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder resources(List<WorkRequestResource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.__explicitlySet__.add("parentId");
            return this;
        }

        public Builder childrenIds(List<String> childrenIds) {
            this.childrenIds = childrenIds;
            this.__explicitlySet__.add("childrenIds");
            return this;
        }

        public WorkRequest build() {
            WorkRequest __instance__ = new WorkRequest(this.operationType, this.status, this.id, this.compartmentId, this.description, this.message, this.managedInstanceId, this.resources, this.percentComplete, this.timeAccepted, this.timeStarted, this.timeFinished, this.osFamily, this.parentId, this.childrenIds);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WorkRequest o) {
            Builder copiedBuilder = this.operationType(o.getOperationType()).status(o.getStatus()).id(o.getId()).compartmentId(o.getCompartmentId()).description(o.getDescription()).message(o.getMessage()).managedInstanceId(o.getManagedInstanceId()).resources(o.getResources()).percentComplete(o.getPercentComplete()).timeAccepted(o.getTimeAccepted()).timeStarted(o.getTimeStarted()).timeFinished(o.getTimeFinished()).osFamily(o.getOsFamily()).parentId(o.getParentId()).childrenIds(o.getChildrenIds());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }
}

