/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ModuleStreamProfile;
import com.oracle.bmc.osmanagement.requests.GetModuleStreamProfileRequest;
import com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetModuleStreamProfileConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetModuleStreamProfileConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetModuleStreamProfileRequest interceptRequest(GetModuleStreamProfileRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetModuleStreamProfileRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSoftwareSourceId(), (String)"softwareSourceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getModuleName(), (String)"moduleName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getStreamName(), (String)"streamName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProfileName(), (String)"profileName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("softwareSources").path(HttpUtils.encodePathSegment((String)request.getSoftwareSourceId())).path("modules").path(HttpUtils.encodePathSegment((String)request.getModuleName())).path("streams").path(HttpUtils.encodePathSegment((String)request.getStreamName())).path("profiles").path(HttpUtils.encodePathSegment((String)request.getProfileName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetModuleStreamProfileResponse> fromResponse() {
        Function<Response, GetModuleStreamProfileResponse> transformer = new Function<Response, GetModuleStreamProfileResponse>(){

            public GetModuleStreamProfileResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetModuleStreamProfileResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ModuleStreamProfile.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetModuleStreamProfileResponse.Builder builder = GetModuleStreamProfileResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.moduleStreamProfile((ModuleStreamProfile)response.getItem());
                Optional opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id");
                if (opcWorkRequestIdHeader.isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetModuleStreamProfileResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

