/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListRelatedEventsRequest
extends BmcRequest<Void> {
    private String eventFingerprint;
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Date latestTimestampLessThan;
    private Date latestTimestampGreaterThanOrEqualTo;

    @ConstructorProperties(value={"eventFingerprint", "compartmentId", "opcRequestId", "limit", "page", "sortOrder", "sortBy", "latestTimestampLessThan", "latestTimestampGreaterThanOrEqualTo"})
    ListRelatedEventsRequest(String eventFingerprint, String compartmentId, String opcRequestId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, Date latestTimestampLessThan, Date latestTimestampGreaterThanOrEqualTo) {
        this.eventFingerprint = eventFingerprint;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.latestTimestampLessThan = latestTimestampLessThan;
        this.latestTimestampGreaterThanOrEqualTo = latestTimestampGreaterThanOrEqualTo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().eventFingerprint(this.eventFingerprint).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).latestTimestampLessThan(this.latestTimestampLessThan).latestTimestampGreaterThanOrEqualTo(this.latestTimestampGreaterThanOrEqualTo);
    }

    public String toString() {
        return "ListRelatedEventsRequest(super=" + super.toString() + ", eventFingerprint=" + this.getEventFingerprint() + ", compartmentId=" + this.getCompartmentId() + ", opcRequestId=" + this.getOpcRequestId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", latestTimestampLessThan=" + this.getLatestTimestampLessThan() + ", latestTimestampGreaterThanOrEqualTo=" + this.getLatestTimestampGreaterThanOrEqualTo() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRelatedEventsRequest)) {
            return false;
        }
        ListRelatedEventsRequest other = (ListRelatedEventsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$eventFingerprint = this.getEventFingerprint();
        String other$eventFingerprint = other.getEventFingerprint();
        if (this$eventFingerprint == null ? other$eventFingerprint != null : !this$eventFingerprint.equals(other$eventFingerprint)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        Date this$latestTimestampLessThan = this.getLatestTimestampLessThan();
        Date other$latestTimestampLessThan = other.getLatestTimestampLessThan();
        if (this$latestTimestampLessThan == null ? other$latestTimestampLessThan != null : !((Object)this$latestTimestampLessThan).equals(other$latestTimestampLessThan)) {
            return false;
        }
        Date this$latestTimestampGreaterThanOrEqualTo = this.getLatestTimestampGreaterThanOrEqualTo();
        Date other$latestTimestampGreaterThanOrEqualTo = other.getLatestTimestampGreaterThanOrEqualTo();
        return !(this$latestTimestampGreaterThanOrEqualTo == null ? other$latestTimestampGreaterThanOrEqualTo != null : !((Object)this$latestTimestampGreaterThanOrEqualTo).equals(other$latestTimestampGreaterThanOrEqualTo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListRelatedEventsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $eventFingerprint = this.getEventFingerprint();
        result = result * 59 + ($eventFingerprint == null ? 43 : $eventFingerprint.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        Date $latestTimestampLessThan = this.getLatestTimestampLessThan();
        result = result * 59 + ($latestTimestampLessThan == null ? 43 : ((Object)$latestTimestampLessThan).hashCode());
        Date $latestTimestampGreaterThanOrEqualTo = this.getLatestTimestampGreaterThanOrEqualTo();
        result = result * 59 + ($latestTimestampGreaterThanOrEqualTo == null ? 43 : ((Object)$latestTimestampGreaterThanOrEqualTo).hashCode());
        return result;
    }

    public String getEventFingerprint() {
        return this.eventFingerprint;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Date getLatestTimestampLessThan() {
        return this.latestTimestampLessThan;
    }

    public Date getLatestTimestampGreaterThanOrEqualTo() {
        return this.latestTimestampGreaterThanOrEqualTo;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRelatedEventsRequest, Void> {
        private String eventFingerprint;
        private String compartmentId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private Date latestTimestampLessThan;
        private Date latestTimestampGreaterThanOrEqualTo;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRelatedEventsRequest o) {
            this.eventFingerprint(o.getEventFingerprint());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.latestTimestampLessThan(o.getLatestTimestampLessThan());
            this.latestTimestampGreaterThanOrEqualTo(o.getLatestTimestampGreaterThanOrEqualTo());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRelatedEventsRequest build() {
            ListRelatedEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder eventFingerprint(String eventFingerprint) {
            this.eventFingerprint = eventFingerprint;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder latestTimestampLessThan(Date latestTimestampLessThan) {
            this.latestTimestampLessThan = latestTimestampLessThan;
            return this;
        }

        public Builder latestTimestampGreaterThanOrEqualTo(Date latestTimestampGreaterThanOrEqualTo) {
            this.latestTimestampGreaterThanOrEqualTo = latestTimestampGreaterThanOrEqualTo;
            return this;
        }

        public ListRelatedEventsRequest buildWithoutInvocationCallback() {
            return new ListRelatedEventsRequest(this.eventFingerprint, this.compartmentId, this.opcRequestId, this.limit, this.page, this.sortOrder, this.sortBy, this.latestTimestampLessThan, this.latestTimestampGreaterThanOrEqualTo);
        }

        public String toString() {
            return "ListRelatedEventsRequest.Builder(eventFingerprint=" + this.eventFingerprint + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", latestTimestampLessThan=" + this.latestTimestampLessThan + ", latestTimestampGreaterThanOrEqualTo=" + this.latestTimestampGreaterThanOrEqualTo + ")";
        }
    }

    public static enum SortBy {
        InstanceId("instanceId"),
        Id("id"),
        EventFingerprint("eventFingerprint");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

