/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class InstallPackageOnManagedInstanceRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String softwarePackageName;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"managedInstanceId", "softwarePackageName", "opcRequestId", "opcRetryToken"})
    InstallPackageOnManagedInstanceRequest(String managedInstanceId, String softwarePackageName, String opcRequestId, String opcRetryToken) {
        this.managedInstanceId = managedInstanceId;
        this.softwarePackageName = softwarePackageName;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).softwarePackageName(this.softwarePackageName).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public String toString() {
        return "InstallPackageOnManagedInstanceRequest(super=" + super.toString() + ", managedInstanceId=" + this.getManagedInstanceId() + ", softwarePackageName=" + this.getSoftwarePackageName() + ", opcRequestId=" + this.getOpcRequestId() + ", opcRetryToken=" + this.getOpcRetryToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstallPackageOnManagedInstanceRequest)) {
            return false;
        }
        InstallPackageOnManagedInstanceRequest other = (InstallPackageOnManagedInstanceRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$managedInstanceId = this.getManagedInstanceId();
        String other$managedInstanceId = other.getManagedInstanceId();
        if (this$managedInstanceId == null ? other$managedInstanceId != null : !this$managedInstanceId.equals(other$managedInstanceId)) {
            return false;
        }
        String this$softwarePackageName = this.getSoftwarePackageName();
        String other$softwarePackageName = other.getSoftwarePackageName();
        if (this$softwarePackageName == null ? other$softwarePackageName != null : !this$softwarePackageName.equals(other$softwarePackageName)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        return !(this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstallPackageOnManagedInstanceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $managedInstanceId = this.getManagedInstanceId();
        result = result * 59 + ($managedInstanceId == null ? 43 : $managedInstanceId.hashCode());
        String $softwarePackageName = this.getSoftwarePackageName();
        result = result * 59 + ($softwarePackageName == null ? 43 : $softwarePackageName.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        return result;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<InstallPackageOnManagedInstanceRequest, Void> {
        private String managedInstanceId;
        private String softwarePackageName;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstallPackageOnManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.softwarePackageName(o.getSoftwarePackageName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstallPackageOnManagedInstanceRequest build() {
            InstallPackageOnManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public InstallPackageOnManagedInstanceRequest buildWithoutInvocationCallback() {
            return new InstallPackageOnManagedInstanceRequest(this.managedInstanceId, this.softwarePackageName, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "InstallPackageOnManagedInstanceRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", softwarePackageName=" + this.softwarePackageName + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

