/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetEventRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private String eventId;
    private String compartmentId;
    private String opcRequestId;

    @ConstructorProperties(value={"managedInstanceId", "eventId", "compartmentId", "opcRequestId"})
    GetEventRequest(String managedInstanceId, String eventId, String compartmentId, String opcRequestId) {
        this.managedInstanceId = managedInstanceId;
        this.eventId = eventId;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).eventId(this.eventId).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetEventRequest(super=" + super.toString() + ", managedInstanceId=" + this.getManagedInstanceId() + ", eventId=" + this.getEventId() + ", compartmentId=" + this.getCompartmentId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEventRequest)) {
            return false;
        }
        GetEventRequest other = (GetEventRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$managedInstanceId = this.getManagedInstanceId();
        String other$managedInstanceId = other.getManagedInstanceId();
        if (this$managedInstanceId == null ? other$managedInstanceId != null : !this$managedInstanceId.equals(other$managedInstanceId)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetEventRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $managedInstanceId = this.getManagedInstanceId();
        result = result * 59 + ($managedInstanceId == null ? 43 : $managedInstanceId.hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEventRequest, Void> {
        private String managedInstanceId;
        private String eventId;
        private String compartmentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEventRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.eventId(o.getEventId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEventRequest build() {
            GetEventRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetEventRequest buildWithoutInvocationCallback() {
            return new GetEventRequest(this.managedInstanceId, this.eventId, this.compartmentId, this.opcRequestId);
        }

        public String toString() {
            return "GetEventRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", eventId=" + this.eventId + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

