/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osmanagement.OsManagement;
import com.oracle.bmc.osmanagement.OsManagementPaginators;
import com.oracle.bmc.osmanagement.OsManagementWaiters;
import com.oracle.bmc.osmanagement.internal.http.AddPackagesToSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachChildSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachManagedInstanceToManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.AttachParentSoftwareSourceToManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeManagedInstanceGroupCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeScheduledJobCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.ChangeSoftwareSourceCompartmentConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.CreateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.DeleteSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachChildSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachManagedInstanceFromManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.DetachParentSoftwareSourceFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetErratumConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.GetScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwarePackageConverter;
import com.oracle.bmc.osmanagement.internal.http.GetSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWindowsUpdateConverter;
import com.oracle.bmc.osmanagement.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllPackageUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllUpdatesOnManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallAllWindowsUpdatesOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallPackageUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.InstallWindowsUpdateOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailablePackagesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableSoftwareSourcesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListAvailableWindowsUpdatesForManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceErrataConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstanceGroupsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListManagedInstancesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListPackagesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListSoftwareSourcesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListUpcomingScheduledJobsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWindowsUpdatesInstalledOnManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.osmanagement.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackageFromManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.RemovePackagesFromSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.internal.http.RunScheduledJobNowConverter;
import com.oracle.bmc.osmanagement.internal.http.SearchSoftwarePackagesConverter;
import com.oracle.bmc.osmanagement.internal.http.SkipNextScheduledJobExecutionConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateManagedInstanceGroupConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateScheduledJobConverter;
import com.oracle.bmc.osmanagement.internal.http.UpdateSoftwareSourceConverter;
import com.oracle.bmc.osmanagement.requests.AddPackagesToSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.AttachChildSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.AttachManagedInstanceToManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.AttachParentSoftwareSourceToManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ChangeManagedInstanceGroupCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeScheduledJobCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.ChangeSoftwareSourceCompartmentRequest;
import com.oracle.bmc.osmanagement.requests.CreateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.CreateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.CreateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DeleteManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DeleteScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.DeleteSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.DetachChildSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.DetachManagedInstanceFromManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.DetachParentSoftwareSourceFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetErratumRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.GetManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwarePackageRequest;
import com.oracle.bmc.osmanagement.requests.GetSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllPackageUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllUpdatesOnManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.InstallAllWindowsUpdatesOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallPackageUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.InstallWindowsUpdateOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailablePackagesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableSoftwareSourcesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListAvailableWindowsUpdatesForManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceErrataRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstanceGroupsRequest;
import com.oracle.bmc.osmanagement.requests.ListManagedInstancesRequest;
import com.oracle.bmc.osmanagement.requests.ListPackagesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcePackagesRequest;
import com.oracle.bmc.osmanagement.requests.ListSoftwareSourcesRequest;
import com.oracle.bmc.osmanagement.requests.ListUpcomingScheduledJobsRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesInstalledOnManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.ListWindowsUpdatesRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.osmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackageFromManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.RemovePackagesFromSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.requests.RunScheduledJobNowRequest;
import com.oracle.bmc.osmanagement.requests.SearchSoftwarePackagesRequest;
import com.oracle.bmc.osmanagement.requests.SkipNextScheduledJobExecutionRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceGroupRequest;
import com.oracle.bmc.osmanagement.requests.UpdateManagedInstanceRequest;
import com.oracle.bmc.osmanagement.requests.UpdateScheduledJobRequest;
import com.oracle.bmc.osmanagement.requests.UpdateSoftwareSourceRequest;
import com.oracle.bmc.osmanagement.responses.AddPackagesToSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.AttachChildSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.AttachManagedInstanceToManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.AttachParentSoftwareSourceToManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ChangeManagedInstanceGroupCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeScheduledJobCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.ChangeSoftwareSourceCompartmentResponse;
import com.oracle.bmc.osmanagement.responses.CreateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.CreateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.CreateSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DeleteManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DeleteScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.DeleteSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.DetachChildSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.DetachManagedInstanceFromManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.DetachParentSoftwareSourceFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetErratumResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.GetManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwarePackageResponse;
import com.oracle.bmc.osmanagement.responses.GetSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.osmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllPackageUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllUpdatesOnManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.InstallAllWindowsUpdatesOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallPackageUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.InstallWindowsUpdateOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailablePackagesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableSoftwareSourcesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListAvailableWindowsUpdatesForManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceErrataResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstanceGroupsResponse;
import com.oracle.bmc.osmanagement.responses.ListManagedInstancesResponse;
import com.oracle.bmc.osmanagement.responses.ListPackagesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcePackagesResponse;
import com.oracle.bmc.osmanagement.responses.ListSoftwareSourcesResponse;
import com.oracle.bmc.osmanagement.responses.ListUpcomingScheduledJobsResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesInstalledOnManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.ListWindowsUpdatesResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.osmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackageFromManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.RemovePackagesFromSoftwareSourceResponse;
import com.oracle.bmc.osmanagement.responses.RunScheduledJobNowResponse;
import com.oracle.bmc.osmanagement.responses.SearchSoftwarePackagesResponse;
import com.oracle.bmc.osmanagement.responses.SkipNextScheduledJobExecutionResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceGroupResponse;
import com.oracle.bmc.osmanagement.responses.UpdateManagedInstanceResponse;
import com.oracle.bmc.osmanagement.responses.UpdateScheduledJobResponse;
import com.oracle.bmc.osmanagement.responses.UpdateSoftwareSourceResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsManagementClient
implements OsManagement {
    private static final Logger LOG = LoggerFactory.getLogger(OsManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OSMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final OsManagementWaiters waiters;
    private final OsManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected OsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration circuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        if (circuitBreakerConfiguration == null) {
            circuitBreakerConfiguration = CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse, isNonBufferingApacheClient, null, circuitBreakerConfiguration);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("OsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OsManagementWaiters(executorService, this);
        this.paginators = new OsManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddPackagesToSoftwareSourceResponse addPackagesToSoftwareSource(AddPackagesToSoftwareSourceRequest request) {
        LOG.trace("Called addPackagesToSoftwareSource");
        AddPackagesToSoftwareSourceRequest interceptedRequest = AddPackagesToSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddPackagesToSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddPackagesToSoftwareSourceResponse> transformer = AddPackagesToSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (AddPackagesToSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddPackagesToSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddPackagesToSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (AddPackagesToSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachChildSoftwareSourceToManagedInstanceResponse attachChildSoftwareSourceToManagedInstance(AttachChildSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachChildSoftwareSourceToManagedInstance");
        AttachChildSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachChildSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachChildSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachChildSoftwareSourceToManagedInstanceResponse> transformer = AttachChildSoftwareSourceToManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachChildSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachChildSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachManagedInstanceToManagedInstanceGroupResponse attachManagedInstanceToManagedInstanceGroup(AttachManagedInstanceToManagedInstanceGroupRequest request) {
        LOG.trace("Called attachManagedInstanceToManagedInstanceGroup");
        AttachManagedInstanceToManagedInstanceGroupRequest interceptedRequest = AttachManagedInstanceToManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachManagedInstanceToManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachManagedInstanceToManagedInstanceGroupResponse> transformer = AttachManagedInstanceToManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (AttachManagedInstanceToManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public AttachParentSoftwareSourceToManagedInstanceResponse attachParentSoftwareSourceToManagedInstance(AttachParentSoftwareSourceToManagedInstanceRequest request) {
        LOG.trace("Called attachParentSoftwareSourceToManagedInstance");
        AttachParentSoftwareSourceToManagedInstanceRequest interceptedRequest = AttachParentSoftwareSourceToManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachParentSoftwareSourceToManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachParentSoftwareSourceToManagedInstanceResponse> transformer = AttachParentSoftwareSourceToManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAttachParentSoftwareSourceToManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (AttachParentSoftwareSourceToManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeManagedInstanceGroupCompartmentResponse changeManagedInstanceGroupCompartment(ChangeManagedInstanceGroupCompartmentRequest request) {
        LOG.trace("Called changeManagedInstanceGroupCompartment");
        ChangeManagedInstanceGroupCompartmentRequest interceptedRequest = ChangeManagedInstanceGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedInstanceGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagedInstanceGroupCompartmentResponse> transformer = ChangeManagedInstanceGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeManagedInstanceGroupCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagedInstanceGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagedInstanceGroupCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeScheduledJobCompartmentResponse changeScheduledJobCompartment(ChangeScheduledJobCompartmentRequest request) {
        LOG.trace("Called changeScheduledJobCompartment");
        ChangeScheduledJobCompartmentRequest interceptedRequest = ChangeScheduledJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeScheduledJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeScheduledJobCompartmentResponse> transformer = ChangeScheduledJobCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeScheduledJobCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeScheduledJobCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeScheduledJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeScheduledJobCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ChangeSoftwareSourceCompartmentResponse changeSoftwareSourceCompartment(ChangeSoftwareSourceCompartmentRequest request) {
        LOG.trace("Called changeSoftwareSourceCompartment");
        ChangeSoftwareSourceCompartmentRequest interceptedRequest = ChangeSoftwareSourceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSoftwareSourceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSoftwareSourceCompartmentResponse> transformer = ChangeSoftwareSourceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ChangeSoftwareSourceCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSoftwareSourceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSoftwareSourceCompartmentResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateManagedInstanceGroupResponse createManagedInstanceGroup(CreateManagedInstanceGroupRequest request) {
        LOG.trace("Called createManagedInstanceGroup");
        CreateManagedInstanceGroupRequest interceptedRequest = CreateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagedInstanceGroupResponse> transformer = CreateManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateScheduledJobResponse createScheduledJob(CreateScheduledJobRequest request) {
        LOG.trace("Called createScheduledJob");
        CreateScheduledJobRequest interceptedRequest = CreateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateScheduledJobResponse> transformer = CreateScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (CreateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public CreateSoftwareSourceResponse createSoftwareSource(CreateSoftwareSourceRequest request) {
        LOG.trace("Called createSoftwareSource");
        CreateSoftwareSourceRequest interceptedRequest = CreateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSoftwareSourceResponse> transformer = CreateSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (CreateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (CreateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteManagedInstanceGroupResponse deleteManagedInstanceGroup(DeleteManagedInstanceGroupRequest request) {
        LOG.trace("Called deleteManagedInstanceGroup");
        DeleteManagedInstanceGroupRequest interceptedRequest = DeleteManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagedInstanceGroupResponse> transformer = DeleteManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteScheduledJobResponse deleteScheduledJob(DeleteScheduledJobRequest request) {
        LOG.trace("Called deleteScheduledJob");
        DeleteScheduledJobRequest interceptedRequest = DeleteScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteScheduledJobResponse> transformer = DeleteScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DeleteSoftwareSourceResponse deleteSoftwareSource(DeleteSoftwareSourceRequest request) {
        LOG.trace("Called deleteSoftwareSource");
        DeleteSoftwareSourceRequest interceptedRequest = DeleteSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSoftwareSourceResponse> transformer = DeleteSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DeleteSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachChildSoftwareSourceFromManagedInstanceResponse detachChildSoftwareSourceFromManagedInstance(DetachChildSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachChildSoftwareSourceFromManagedInstance");
        DetachChildSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachChildSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachChildSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachChildSoftwareSourceFromManagedInstanceResponse> transformer = DetachChildSoftwareSourceFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachChildSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachChildSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachManagedInstanceFromManagedInstanceGroupResponse detachManagedInstanceFromManagedInstanceGroup(DetachManagedInstanceFromManagedInstanceGroupRequest request) {
        LOG.trace("Called detachManagedInstanceFromManagedInstanceGroup");
        DetachManagedInstanceFromManagedInstanceGroupRequest interceptedRequest = DetachManagedInstanceFromManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachManagedInstanceFromManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachManagedInstanceFromManagedInstanceGroupResponse> transformer = DetachManagedInstanceFromManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DetachManagedInstanceFromManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public DetachParentSoftwareSourceFromManagedInstanceResponse detachParentSoftwareSourceFromManagedInstance(DetachParentSoftwareSourceFromManagedInstanceRequest request) {
        LOG.trace("Called detachParentSoftwareSourceFromManagedInstance");
        DetachParentSoftwareSourceFromManagedInstanceRequest interceptedRequest = DetachParentSoftwareSourceFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachParentSoftwareSourceFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachParentSoftwareSourceFromManagedInstanceResponse> transformer = DetachParentSoftwareSourceFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetachParentSoftwareSourceFromManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (DetachParentSoftwareSourceFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetErratumResponse getErratum(GetErratumRequest request) {
        LOG.trace("Called getErratum");
        GetErratumRequest interceptedRequest = GetErratumConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetErratumConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetErratumResponse> transformer = GetErratumConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetErratumResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetErratumResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetErratumResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceResponse getManagedInstance(GetManagedInstanceRequest request) {
        LOG.trace("Called getManagedInstance");
        GetManagedInstanceRequest interceptedRequest = GetManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedInstanceResponse> transformer = GetManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetManagedInstanceGroupResponse getManagedInstanceGroup(GetManagedInstanceGroupRequest request) {
        LOG.trace("Called getManagedInstanceGroup");
        GetManagedInstanceGroupRequest interceptedRequest = GetManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedInstanceGroupResponse> transformer = GetManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetScheduledJobResponse getScheduledJob(GetScheduledJobRequest request) {
        LOG.trace("Called getScheduledJob");
        GetScheduledJobRequest interceptedRequest = GetScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetScheduledJobResponse> transformer = GetScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwarePackageResponse getSoftwarePackage(GetSoftwarePackageRequest request) {
        LOG.trace("Called getSoftwarePackage");
        GetSoftwarePackageRequest interceptedRequest = GetSoftwarePackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwarePackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSoftwarePackageResponse> transformer = GetSoftwarePackageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetSoftwarePackageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwarePackageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwarePackageResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetSoftwareSourceResponse getSoftwareSource(GetSoftwareSourceRequest request) {
        LOG.trace("Called getSoftwareSource");
        GetSoftwareSourceRequest interceptedRequest = GetSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSoftwareSourceResponse> transformer = GetSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWindowsUpdateResponse getWindowsUpdate(GetWindowsUpdateRequest request) {
        LOG.trace("Called getWindowsUpdate");
        GetWindowsUpdateRequest interceptedRequest = GetWindowsUpdateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWindowsUpdateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWindowsUpdateResponse> transformer = GetWindowsUpdateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetWindowsUpdateResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWindowsUpdateResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWindowsUpdateResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllPackageUpdatesOnManagedInstanceResponse installAllPackageUpdatesOnManagedInstance(InstallAllPackageUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllPackageUpdatesOnManagedInstance");
        InstallAllPackageUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllPackageUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllPackageUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllPackageUpdatesOnManagedInstanceResponse> transformer = InstallAllPackageUpdatesOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllPackageUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllUpdatesOnManagedInstanceGroupResponse installAllUpdatesOnManagedInstanceGroup(InstallAllUpdatesOnManagedInstanceGroupRequest request) {
        LOG.trace("Called installAllUpdatesOnManagedInstanceGroup");
        InstallAllUpdatesOnManagedInstanceGroupRequest interceptedRequest = InstallAllUpdatesOnManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllUpdatesOnManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllUpdatesOnManagedInstanceGroupResponse> transformer = InstallAllUpdatesOnManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllUpdatesOnManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallAllWindowsUpdatesOnManagedInstanceResponse installAllWindowsUpdatesOnManagedInstance(InstallAllWindowsUpdatesOnManagedInstanceRequest request) {
        LOG.trace("Called installAllWindowsUpdatesOnManagedInstance");
        InstallAllWindowsUpdatesOnManagedInstanceRequest interceptedRequest = InstallAllWindowsUpdatesOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallAllWindowsUpdatesOnManagedInstanceResponse> transformer = InstallAllWindowsUpdatesOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallAllWindowsUpdatesOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageOnManagedInstanceResponse installPackageOnManagedInstance(InstallPackageOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageOnManagedInstance");
        InstallPackageOnManagedInstanceRequest interceptedRequest = InstallPackageOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallPackageOnManagedInstanceResponse> transformer = InstallPackageOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallPackageOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallPackageUpdateOnManagedInstanceResponse installPackageUpdateOnManagedInstance(InstallPackageUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installPackageUpdateOnManagedInstance");
        InstallPackageUpdateOnManagedInstanceRequest interceptedRequest = InstallPackageUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallPackageUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallPackageUpdateOnManagedInstanceResponse> transformer = InstallPackageUpdateOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallPackageUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallPackageUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public InstallWindowsUpdateOnManagedInstanceResponse installWindowsUpdateOnManagedInstance(InstallWindowsUpdateOnManagedInstanceRequest request) {
        LOG.trace("Called installWindowsUpdateOnManagedInstance");
        InstallWindowsUpdateOnManagedInstanceRequest interceptedRequest = InstallWindowsUpdateOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = InstallWindowsUpdateOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, InstallWindowsUpdateOnManagedInstanceResponse> transformer = InstallWindowsUpdateOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (InstallWindowsUpdateOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailablePackagesForManagedInstanceResponse listAvailablePackagesForManagedInstance(ListAvailablePackagesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailablePackagesForManagedInstance");
        ListAvailablePackagesForManagedInstanceRequest interceptedRequest = ListAvailablePackagesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailablePackagesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailablePackagesForManagedInstanceResponse> transformer = ListAvailablePackagesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListAvailablePackagesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailablePackagesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableSoftwareSourcesForManagedInstanceResponse listAvailableSoftwareSourcesForManagedInstance(ListAvailableSoftwareSourcesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableSoftwareSourcesForManagedInstance");
        ListAvailableSoftwareSourcesForManagedInstanceRequest interceptedRequest = ListAvailableSoftwareSourcesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableSoftwareSourcesForManagedInstanceResponse> transformer = ListAvailableSoftwareSourcesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableSoftwareSourcesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableUpdatesForManagedInstanceResponse listAvailableUpdatesForManagedInstance(ListAvailableUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableUpdatesForManagedInstance");
        ListAvailableUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableUpdatesForManagedInstanceResponse> transformer = ListAvailableUpdatesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListAvailableUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListAvailableWindowsUpdatesForManagedInstanceResponse listAvailableWindowsUpdatesForManagedInstance(ListAvailableWindowsUpdatesForManagedInstanceRequest request) {
        LOG.trace("Called listAvailableWindowsUpdatesForManagedInstance");
        ListAvailableWindowsUpdatesForManagedInstanceRequest interceptedRequest = ListAvailableWindowsUpdatesForManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAvailableWindowsUpdatesForManagedInstanceResponse> transformer = ListAvailableWindowsUpdatesForManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAvailableWindowsUpdatesForManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListErrataResponse listErrata(ListErrataRequest request) {
        LOG.trace("Called listErrata");
        ListErrataRequest interceptedRequest = ListErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListErrataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListErrataResponse> transformer = ListErrataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceErrataResponse listManagedInstanceErrata(ListManagedInstanceErrataRequest request) {
        LOG.trace("Called listManagedInstanceErrata");
        ListManagedInstanceErrataRequest interceptedRequest = ListManagedInstanceErrataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceErrataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstanceErrataResponse> transformer = ListManagedInstanceErrataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListManagedInstanceErrataResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceErrataResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceErrataResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstanceGroupsResponse listManagedInstanceGroups(ListManagedInstanceGroupsRequest request) {
        LOG.trace("Called listManagedInstanceGroups");
        ListManagedInstanceGroupsRequest interceptedRequest = ListManagedInstanceGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstanceGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstanceGroupsResponse> transformer = ListManagedInstanceGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListManagedInstanceGroupsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstanceGroupsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstanceGroupsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListManagedInstancesResponse listManagedInstances(ListManagedInstancesRequest request) {
        LOG.trace("Called listManagedInstances");
        ListManagedInstancesRequest interceptedRequest = ListManagedInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedInstancesResponse> transformer = ListManagedInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListManagedInstancesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedInstancesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedInstancesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListPackagesInstalledOnManagedInstanceResponse listPackagesInstalledOnManagedInstance(ListPackagesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listPackagesInstalledOnManagedInstance");
        ListPackagesInstalledOnManagedInstanceRequest interceptedRequest = ListPackagesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPackagesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPackagesInstalledOnManagedInstanceResponse> transformer = ListPackagesInstalledOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListPackagesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPackagesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListScheduledJobsResponse listScheduledJobs(ListScheduledJobsRequest request) {
        LOG.trace("Called listScheduledJobs");
        ListScheduledJobsRequest interceptedRequest = ListScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListScheduledJobsResponse> transformer = ListScheduledJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcePackagesResponse listSoftwareSourcePackages(ListSoftwareSourcePackagesRequest request) {
        LOG.trace("Called listSoftwareSourcePackages");
        ListSoftwareSourcePackagesRequest interceptedRequest = ListSoftwareSourcePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcePackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSoftwareSourcePackagesResponse> transformer = ListSoftwareSourcePackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListSoftwareSourcePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListSoftwareSourcesResponse listSoftwareSources(ListSoftwareSourcesRequest request) {
        LOG.trace("Called listSoftwareSources");
        ListSoftwareSourcesRequest interceptedRequest = ListSoftwareSourcesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSoftwareSourcesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSoftwareSourcesResponse> transformer = ListSoftwareSourcesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListSoftwareSourcesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSoftwareSourcesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSoftwareSourcesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListUpcomingScheduledJobsResponse listUpcomingScheduledJobs(ListUpcomingScheduledJobsRequest request) {
        LOG.trace("Called listUpcomingScheduledJobs");
        ListUpcomingScheduledJobsRequest interceptedRequest = ListUpcomingScheduledJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUpcomingScheduledJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUpcomingScheduledJobsResponse> transformer = ListUpcomingScheduledJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListUpcomingScheduledJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListUpcomingScheduledJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListUpcomingScheduledJobsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesResponse listWindowsUpdates(ListWindowsUpdatesRequest request) {
        LOG.trace("Called listWindowsUpdates");
        ListWindowsUpdatesRequest interceptedRequest = ListWindowsUpdatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWindowsUpdatesResponse> transformer = ListWindowsUpdatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWindowsUpdatesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWindowsUpdatesInstalledOnManagedInstanceResponse listWindowsUpdatesInstalledOnManagedInstance(ListWindowsUpdatesInstalledOnManagedInstanceRequest request) {
        LOG.trace("Called listWindowsUpdatesInstalledOnManagedInstance");
        ListWindowsUpdatesInstalledOnManagedInstanceRequest interceptedRequest = ListWindowsUpdatesInstalledOnManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWindowsUpdatesInstalledOnManagedInstanceResponse> transformer = ListWindowsUpdatesInstalledOnManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWindowsUpdatesInstalledOnManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackageFromManagedInstanceResponse removePackageFromManagedInstance(RemovePackageFromManagedInstanceRequest request) {
        LOG.trace("Called removePackageFromManagedInstance");
        RemovePackageFromManagedInstanceRequest interceptedRequest = RemovePackageFromManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackageFromManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemovePackageFromManagedInstanceResponse> transformer = RemovePackageFromManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (RemovePackageFromManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackageFromManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RemovePackageFromManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RemovePackagesFromSoftwareSourceResponse removePackagesFromSoftwareSource(RemovePackagesFromSoftwareSourceRequest request) {
        LOG.trace("Called removePackagesFromSoftwareSource");
        RemovePackagesFromSoftwareSourceRequest interceptedRequest = RemovePackagesFromSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemovePackagesFromSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemovePackagesFromSoftwareSourceResponse> transformer = RemovePackagesFromSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (RemovePackagesFromSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemovePackagesFromSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (RemovePackagesFromSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public RunScheduledJobNowResponse runScheduledJobNow(RunScheduledJobNowRequest request) {
        LOG.trace("Called runScheduledJobNow");
        RunScheduledJobNowRequest interceptedRequest = RunScheduledJobNowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RunScheduledJobNowConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RunScheduledJobNowResponse> transformer = RunScheduledJobNowConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (RunScheduledJobNowResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RunScheduledJobNowResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (RunScheduledJobNowResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SearchSoftwarePackagesResponse searchSoftwarePackages(SearchSoftwarePackagesRequest request) {
        LOG.trace("Called searchSoftwarePackages");
        SearchSoftwarePackagesRequest interceptedRequest = SearchSoftwarePackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SearchSoftwarePackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SearchSoftwarePackagesResponse> transformer = SearchSoftwarePackagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (SearchSoftwarePackagesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SearchSoftwarePackagesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SearchSoftwarePackagesResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public SkipNextScheduledJobExecutionResponse skipNextScheduledJobExecution(SkipNextScheduledJobExecutionRequest request) {
        LOG.trace("Called skipNextScheduledJobExecution");
        SkipNextScheduledJobExecutionRequest interceptedRequest = SkipNextScheduledJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SkipNextScheduledJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SkipNextScheduledJobExecutionResponse> transformer = SkipNextScheduledJobExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (SkipNextScheduledJobExecutionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SkipNextScheduledJobExecutionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (SkipNextScheduledJobExecutionResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceResponse updateManagedInstance(UpdateManagedInstanceRequest request) {
        LOG.trace("Called updateManagedInstance");
        UpdateManagedInstanceRequest interceptedRequest = UpdateManagedInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedInstanceResponse> transformer = UpdateManagedInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateManagedInstanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateManagedInstanceGroupResponse updateManagedInstanceGroup(UpdateManagedInstanceGroupRequest request) {
        LOG.trace("Called updateManagedInstanceGroup");
        UpdateManagedInstanceGroupRequest interceptedRequest = UpdateManagedInstanceGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedInstanceGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedInstanceGroupResponse> transformer = UpdateManagedInstanceGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateManagedInstanceGroupResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedInstanceGroupResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedInstanceGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedInstanceGroupResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateScheduledJobResponse updateScheduledJob(UpdateScheduledJobRequest request) {
        LOG.trace("Called updateScheduledJob");
        UpdateScheduledJobRequest interceptedRequest = UpdateScheduledJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateScheduledJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateScheduledJobResponse> transformer = UpdateScheduledJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateScheduledJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateScheduledJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateScheduledJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateScheduledJobResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public UpdateSoftwareSourceResponse updateSoftwareSource(UpdateSoftwareSourceRequest request) {
        LOG.trace("Called updateSoftwareSource");
        UpdateSoftwareSourceRequest interceptedRequest = UpdateSoftwareSourceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSoftwareSourceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSoftwareSourceResponse> transformer = UpdateSoftwareSourceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        return (UpdateSoftwareSourceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSoftwareSourceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSoftwareSourceDetails(), (BmcRequest)retriedRequest);
                return (UpdateSoftwareSourceResponse)((Object)((Object)((Object)transformer.apply((Object)response))));
            })));
        }));
    }

    @Override
    public OsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OsManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OsManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OsManagementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OsManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

