/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSoftwareSourceRequest
extends BmcRequest<Void> {
    private String softwareSourceId;
    private String opcRequestId;

    @ConstructorProperties(value={"softwareSourceId", "opcRequestId"})
    GetSoftwareSourceRequest(String softwareSourceId, String opcRequestId) {
        this.softwareSourceId = softwareSourceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().softwareSourceId(this.softwareSourceId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetSoftwareSourceRequest(super=" + super.toString() + ", softwareSourceId=" + this.getSoftwareSourceId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetSoftwareSourceRequest)) {
            return false;
        }
        GetSoftwareSourceRequest other = (GetSoftwareSourceRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$softwareSourceId = this.getSoftwareSourceId();
        String other$softwareSourceId = other.getSoftwareSourceId();
        if (this$softwareSourceId == null ? other$softwareSourceId != null : !this$softwareSourceId.equals(other$softwareSourceId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetSoftwareSourceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $softwareSourceId = this.getSoftwareSourceId();
        result = result * 59 + ($softwareSourceId == null ? 43 : $softwareSourceId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSoftwareSourceRequest, Void> {
        private String softwareSourceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSoftwareSourceRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSoftwareSourceRequest build() {
            GetSoftwareSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSoftwareSourceRequest buildWithoutInvocationCallback() {
            return new GetSoftwareSourceRequest(this.softwareSourceId, this.opcRequestId);
        }

        public String toString() {
            return "GetSoftwareSourceRequest.Builder(softwareSourceId=" + this.softwareSourceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

