/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.osmanagement.model.LifecycleStates;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListUpcomingScheduledJobsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Date timeEnd;
    private String displayName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String tagName;
    private String tagValue;
    private LifecycleStates lifecycleState;
    private String opcRequestId;
    private OsFamilies osFamily;

    @ConstructorProperties(value={"compartmentId", "timeEnd", "displayName", "limit", "page", "sortOrder", "sortBy", "tagName", "tagValue", "lifecycleState", "opcRequestId", "osFamily"})
    ListUpcomingScheduledJobsRequest(String compartmentId, Date timeEnd, String displayName, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String tagName, String tagValue, LifecycleStates lifecycleState, String opcRequestId, OsFamilies osFamily) {
        this.compartmentId = compartmentId;
        this.timeEnd = timeEnd;
        this.displayName = displayName;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.tagName = tagName;
        this.tagValue = tagValue;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
        this.osFamily = osFamily;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).timeEnd(this.timeEnd).displayName(this.displayName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).tagName(this.tagName).tagValue(this.tagValue).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId).osFamily(this.osFamily);
    }

    public String toString() {
        return "ListUpcomingScheduledJobsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", timeEnd=" + this.getTimeEnd() + ", displayName=" + this.getDisplayName() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", tagName=" + this.getTagName() + ", tagValue=" + this.getTagValue() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", opcRequestId=" + this.getOpcRequestId() + ", osFamily=" + (Object)((Object)this.getOsFamily()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListUpcomingScheduledJobsRequest)) {
            return false;
        }
        ListUpcomingScheduledJobsRequest other = (ListUpcomingScheduledJobsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        Date this$timeEnd = this.getTimeEnd();
        Date other$timeEnd = other.getTimeEnd();
        if (this$timeEnd == null ? other$timeEnd != null : !((Object)this$timeEnd).equals(other$timeEnd)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        String this$tagValue = this.getTagValue();
        String other$tagValue = other.getTagValue();
        if (this$tagValue == null ? other$tagValue != null : !this$tagValue.equals(other$tagValue)) {
            return false;
        }
        LifecycleStates this$lifecycleState = this.getLifecycleState();
        LifecycleStates other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        OsFamilies this$osFamily = this.getOsFamily();
        OsFamilies other$osFamily = other.getOsFamily();
        return !(this$osFamily == null ? other$osFamily != null : !((Object)((Object)this$osFamily)).equals((Object)other$osFamily));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListUpcomingScheduledJobsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        Date $timeEnd = this.getTimeEnd();
        result = result * 59 + ($timeEnd == null ? 43 : ((Object)$timeEnd).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        String $tagValue = this.getTagValue();
        result = result * 59 + ($tagValue == null ? 43 : $tagValue.hashCode());
        LifecycleStates $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        OsFamilies $osFamily = this.getOsFamily();
        result = result * 59 + ($osFamily == null ? 43 : ((Object)((Object)$osFamily)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUpcomingScheduledJobsRequest, Void> {
        private String compartmentId;
        private Date timeEnd;
        private String displayName;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String tagName;
        private String tagValue;
        private LifecycleStates lifecycleState;
        private String opcRequestId;
        private OsFamilies osFamily;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUpcomingScheduledJobsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.timeEnd(o.getTimeEnd());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.tagName(o.getTagName());
            this.tagValue(o.getTagValue());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.osFamily(o.getOsFamily());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUpcomingScheduledJobsRequest build() {
            ListUpcomingScheduledJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public ListUpcomingScheduledJobsRequest buildWithoutInvocationCallback() {
            return new ListUpcomingScheduledJobsRequest(this.compartmentId, this.timeEnd, this.displayName, this.limit, this.page, this.sortOrder, this.sortBy, this.tagName, this.tagValue, this.lifecycleState, this.opcRequestId, this.osFamily);
        }

        public String toString() {
            return "ListUpcomingScheduledJobsRequest.Builder(compartmentId=" + this.compartmentId + ", timeEnd=" + this.timeEnd + ", displayName=" + this.displayName + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", tagName=" + this.tagName + ", tagValue=" + this.tagValue + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", opcRequestId=" + this.opcRequestId + ", osFamily=" + (Object)((Object)this.osFamily) + ")";
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

