/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.WindowsUpdateSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWindowsUpdatesResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<WindowsUpdateSummary> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListWindowsUpdatesResponse(String opcRequestId, String opcNextPage, List<WindowsUpdateSummary> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<WindowsUpdateSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<WindowsUpdateSummary> items;

        public Builder copy(ListWindowsUpdatesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<WindowsUpdateSummary> items) {
            this.items = items;
            return this;
        }

        public ListWindowsUpdatesResponse build() {
            return new ListWindowsUpdatesResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListWindowsUpdatesResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

