/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.WindowsUpdate;
import com.oracle.bmc.osmanagement.requests.GetWindowsUpdateRequest;
import com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetWindowsUpdateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetWindowsUpdateConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetWindowsUpdateRequest interceptRequest(GetWindowsUpdateRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetWindowsUpdateRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWindowsUpdate(), (String)"windowsUpdate must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("updates").path(HttpUtils.encodePathSegment((String)request.getWindowsUpdate()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetWindowsUpdateResponse> fromResponse() {
        Function<Response, GetWindowsUpdateResponse> transformer = new Function<Response, GetWindowsUpdateResponse>(){

            public GetWindowsUpdateResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.osmanagement.responses.GetWindowsUpdateResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(WindowsUpdate.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetWindowsUpdateResponse.Builder builder = GetWindowsUpdateResponse.builder();
                builder.windowsUpdate((WindowsUpdate)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetWindowsUpdateResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

