/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.SoftwareSource;
import java.beans.ConstructorProperties;

public class CreateSoftwareSourceResponse {
    private String location;
    private String opcRequestId;
    private String etag;
    private SoftwareSource softwareSource;

    @ConstructorProperties(value={"location", "opcRequestId", "etag", "softwareSource"})
    CreateSoftwareSourceResponse(String location, String opcRequestId, String etag, SoftwareSource softwareSource) {
        this.location = location;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.softwareSource = softwareSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLocation() {
        return this.location;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public SoftwareSource getSoftwareSource() {
        return this.softwareSource;
    }

    public static class Builder {
        private String location;
        private String opcRequestId;
        private String etag;
        private SoftwareSource softwareSource;

        public Builder copy(CreateSoftwareSourceResponse o) {
            this.location(o.getLocation());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.softwareSource(o.getSoftwareSource());
            return this;
        }

        Builder() {
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder softwareSource(SoftwareSource softwareSource) {
            this.softwareSource = softwareSource;
            return this;
        }

        public CreateSoftwareSourceResponse build() {
            return new CreateSoftwareSourceResponse(this.location, this.opcRequestId, this.etag, this.softwareSource);
        }

        public String toString() {
            return "CreateSoftwareSourceResponse.Builder(location=" + this.location + ", opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", softwareSource=" + this.softwareSource + ")";
        }
    }
}

