/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSoftwarePackageRequest
extends BmcRequest<Void> {
    private String softwareSourceId;
    private String softwarePackageName;
    private String opcRequestId;

    @ConstructorProperties(value={"softwareSourceId", "softwarePackageName", "opcRequestId"})
    GetSoftwarePackageRequest(String softwareSourceId, String softwarePackageName, String opcRequestId) {
        this.softwareSourceId = softwareSourceId;
        this.softwarePackageName = softwarePackageName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSoftwarePackageRequest, Void> {
        private String softwareSourceId;
        private String softwarePackageName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSoftwarePackageRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.softwarePackageName(o.getSoftwarePackageName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSoftwarePackageRequest build() {
            GetSoftwarePackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSoftwarePackageRequest buildWithoutInvocationCallback() {
            return new GetSoftwarePackageRequest(this.softwareSourceId, this.softwarePackageName, this.opcRequestId);
        }

        public String toString() {
            return "GetSoftwarePackageRequest.Builder(softwareSourceId=" + this.softwareSourceId + ", softwarePackageName=" + this.softwarePackageName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

