/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.SoftwareSource;
import java.beans.ConstructorProperties;

public class UpdateSoftwareSourceResponse {
    private String etag;
    private String opcRequestId;
    private SoftwareSource softwareSource;

    @ConstructorProperties(value={"etag", "opcRequestId", "softwareSource"})
    UpdateSoftwareSourceResponse(String etag, String opcRequestId, SoftwareSource softwareSource) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.softwareSource = softwareSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SoftwareSource getSoftwareSource() {
        return this.softwareSource;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private SoftwareSource softwareSource;

        public Builder copy(UpdateSoftwareSourceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.softwareSource(o.getSoftwareSource());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder softwareSource(SoftwareSource softwareSource) {
            this.softwareSource = softwareSource;
            return this;
        }

        public UpdateSoftwareSourceResponse build() {
            return new UpdateSoftwareSourceResponse(this.etag, this.opcRequestId, this.softwareSource);
        }

        public String toString() {
            return "UpdateSoftwareSourceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", softwareSource=" + this.softwareSource + ")";
        }
    }
}

