/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.SoftwareSource;
import java.beans.ConstructorProperties;

public class GetSoftwareSourceResponse {
    private String etag;
    private String opcRequestId;
    private Float retryAfter;
    private SoftwareSource softwareSource;

    @ConstructorProperties(value={"etag", "opcRequestId", "retryAfter", "softwareSource"})
    GetSoftwareSourceResponse(String etag, String opcRequestId, Float retryAfter, SoftwareSource softwareSource) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.softwareSource = softwareSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public SoftwareSource getSoftwareSource() {
        return this.softwareSource;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Float retryAfter;
        private SoftwareSource softwareSource;

        public Builder copy(GetSoftwareSourceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.softwareSource(o.getSoftwareSource());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder softwareSource(SoftwareSource softwareSource) {
            this.softwareSource = softwareSource;
            return this;
        }

        public GetSoftwareSourceResponse build() {
            return new GetSoftwareSourceResponse(this.etag, this.opcRequestId, this.retryAfter, this.softwareSource);
        }

        public String toString() {
            return "GetSoftwareSourceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", retryAfter=" + this.retryAfter + ", softwareSource=" + this.softwareSource + ")";
        }
    }
}

