/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.responses;

import com.oracle.bmc.osmanagement.model.ScheduledJob;
import java.beans.ConstructorProperties;

public class GetScheduledJobResponse {
    private String etag;
    private String opcRequestId;
    private Float retryAfter;
    private ScheduledJob scheduledJob;

    @ConstructorProperties(value={"etag", "opcRequestId", "retryAfter", "scheduledJob"})
    GetScheduledJobResponse(String etag, String opcRequestId, Float retryAfter, ScheduledJob scheduledJob) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.retryAfter = retryAfter;
        this.scheduledJob = scheduledJob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public ScheduledJob getScheduledJob() {
        return this.scheduledJob;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Float retryAfter;
        private ScheduledJob scheduledJob;

        public Builder copy(GetScheduledJobResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.retryAfter(o.getRetryAfter());
            this.scheduledJob(o.getScheduledJob());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder scheduledJob(ScheduledJob scheduledJob) {
            this.scheduledJob = scheduledJob;
            return this;
        }

        public GetScheduledJobResponse build() {
            return new GetScheduledJobResponse(this.etag, this.opcRequestId, this.retryAfter, this.scheduledJob);
        }

        public String toString() {
            return "GetScheduledJobResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", retryAfter=" + this.retryAfter + ", scheduledJob=" + this.scheduledJob + ")";
        }
    }
}

