/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class InstallPackageUpdateOnManagedInstanceRequest
extends BmcRequest {
    private String managedInstanceId;
    private String softwarePackageName;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"managedInstanceId", "softwarePackageName", "opcRequestId", "opcRetryToken"})
    InstallPackageUpdateOnManagedInstanceRequest(String managedInstanceId, String softwarePackageName, String opcRequestId, String opcRetryToken) {
        this.managedInstanceId = managedInstanceId;
        this.softwarePackageName = softwarePackageName;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String managedInstanceId;
        private String softwarePackageName;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstallPackageUpdateOnManagedInstanceRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.softwarePackageName(o.getSoftwarePackageName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstallPackageUpdateOnManagedInstanceRequest build() {
            InstallPackageUpdateOnManagedInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public InstallPackageUpdateOnManagedInstanceRequest buildWithoutInvocationCallback() {
            return new InstallPackageUpdateOnManagedInstanceRequest(this.managedInstanceId, this.softwarePackageName, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "InstallPackageUpdateOnManagedInstanceRequest.Builder(managedInstanceId=" + this.managedInstanceId + ", softwarePackageName=" + this.softwarePackageName + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

