/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetScheduledJobRequest
extends BmcRequest {
    private String scheduledJobId;
    private String opcRequestId;

    @ConstructorProperties(value={"scheduledJobId", "opcRequestId"})
    GetScheduledJobRequest(String scheduledJobId, String opcRequestId) {
        this.scheduledJobId = scheduledJobId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getScheduledJobId() {
        return this.scheduledJobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String scheduledJobId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetScheduledJobRequest o) {
            this.scheduledJobId(o.getScheduledJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetScheduledJobRequest build() {
            GetScheduledJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder scheduledJobId(String scheduledJobId) {
            this.scheduledJobId = scheduledJobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetScheduledJobRequest buildWithoutInvocationCallback() {
            return new GetScheduledJobRequest(this.scheduledJobId, this.opcRequestId);
        }

        public String toString() {
            return "GetScheduledJobRequest.Builder(scheduledJobId=" + this.scheduledJobId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

