/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.optimizer.model.UpdateRecommendationDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRecommendationRequest
extends BmcRequest<UpdateRecommendationDetails> {
    private String recommendationId;
    private UpdateRecommendationDetails updateRecommendationDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public UpdateRecommendationDetails getUpdateRecommendationDetails() {
        return this.updateRecommendationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateRecommendationDetails getBody$() {
        return this.updateRecommendationDetails;
    }

    public Builder toBuilder() {
        return new Builder().recommendationId(this.recommendationId).updateRecommendationDetails(this.updateRecommendationDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",recommendationId=").append(String.valueOf(this.recommendationId));
        sb.append(",updateRecommendationDetails=").append(String.valueOf((Object)this.updateRecommendationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRecommendationRequest)) {
            return false;
        }
        UpdateRecommendationRequest other = (UpdateRecommendationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.recommendationId, other.recommendationId) && Objects.equals((Object)this.updateRecommendationDetails, (Object)other.updateRecommendationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recommendationId == null ? 43 : this.recommendationId.hashCode());
        result = result * 59 + (this.updateRecommendationDetails == null ? 43 : this.updateRecommendationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRecommendationRequest, UpdateRecommendationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String recommendationId = null;
        private UpdateRecommendationDetails updateRecommendationDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public Builder updateRecommendationDetails(UpdateRecommendationDetails updateRecommendationDetails) {
            this.updateRecommendationDetails = updateRecommendationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRecommendationRequest o) {
            this.recommendationId(o.getRecommendationId());
            this.updateRecommendationDetails(o.getUpdateRecommendationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRecommendationRequest build() {
            UpdateRecommendationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRecommendationDetails body) {
            this.updateRecommendationDetails(body);
            return this;
        }

        public UpdateRecommendationRequest buildWithoutInvocationCallback() {
            UpdateRecommendationRequest request = new UpdateRecommendationRequest();
            request.recommendationId = this.recommendationId;
            request.updateRecommendationDetails = this.updateRecommendationDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

