/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryableFieldSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldType")
    private final FieldType fieldType;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="objectProperties")
    private final List<QueryableFieldSummary> objectProperties;

    @Deprecated
    @ConstructorProperties(value={"fieldType", "fieldName", "objectProperties"})
    public QueryableFieldSummary(FieldType fieldType, String fieldName, List<QueryableFieldSummary> objectProperties) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.objectProperties = objectProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<QueryableFieldSummary> getObjectProperties() {
        return this.objectProperties;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryableFieldSummary(");
        sb.append("super=").append(super.toString());
        sb.append("fieldType=").append(String.valueOf((Object)this.fieldType));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", objectProperties=").append(String.valueOf(this.objectProperties));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryableFieldSummary)) {
            return false;
        }
        QueryableFieldSummary other = (QueryableFieldSummary)((Object)o);
        return Objects.equals((Object)this.fieldType, (Object)other.fieldType) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.objectProperties, other.objectProperties) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldType == null ? 43 : this.fieldType.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.objectProperties == null ? 43 : this.objectProperties.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FieldType implements BmcEnum
    {
        String("STRING"),
        Integer("INTEGER"),
        Boolean("BOOLEAN"),
        DateTime("DATE_TIME"),
        Object("OBJECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FieldType> map;

        private FieldType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FieldType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FieldType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FieldType.class);
            map = new HashMap<String, FieldType>();
            for (FieldType v : FieldType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldType")
        private FieldType fieldType;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="objectProperties")
        private List<QueryableFieldSummary> objectProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            this.__explicitlySet__.add("fieldType");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder objectProperties(List<QueryableFieldSummary> objectProperties) {
            this.objectProperties = objectProperties;
            this.__explicitlySet__.add("objectProperties");
            return this;
        }

        public QueryableFieldSummary build() {
            QueryableFieldSummary model = new QueryableFieldSummary(this.fieldType, this.fieldName, this.objectProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryableFieldSummary model) {
            if (model.wasPropertyExplicitlySet("fieldType")) {
                this.fieldType(model.getFieldType());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("objectProperties")) {
                this.objectProperties(model.getObjectProperties());
            }
            return this;
        }
    }
}

