/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LevelConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="recommendationId")
    private final String recommendationId;
    @JsonProperty(value="level")
    private final String level;

    @Deprecated
    @ConstructorProperties(value={"recommendationId", "level"})
    public LevelConfiguration(String recommendationId, String level) {
        this.recommendationId = recommendationId;
        this.level = level;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public String getLevel() {
        return this.level;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LevelConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("recommendationId=").append(String.valueOf(this.recommendationId));
        sb.append(", level=").append(String.valueOf(this.level));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LevelConfiguration)) {
            return false;
        }
        LevelConfiguration other = (LevelConfiguration)((Object)o);
        return Objects.equals(this.recommendationId, other.recommendationId) && Objects.equals(this.level, other.level) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.recommendationId == null ? 43 : this.recommendationId.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="recommendationId")
        private String recommendationId;
        @JsonProperty(value="level")
        private String level;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            this.__explicitlySet__.add("recommendationId");
            return this;
        }

        public Builder level(String level) {
            this.level = level;
            this.__explicitlySet__.add("level");
            return this;
        }

        public LevelConfiguration build() {
            LevelConfiguration model = new LevelConfiguration(this.recommendationId, this.level);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LevelConfiguration model) {
            if (model.wasPropertyExplicitlySet("recommendationId")) {
                this.recommendationId(model.getRecommendationId());
            }
            if (model.wasPropertyExplicitlySet("level")) {
                this.level(model.getLevel());
            }
            return this;
        }
    }
}

