/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EvaluatedMetric
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="statistic")
    private final String statistic;
    @JsonProperty(value="threshold")
    private final Double threshold;
    @JsonProperty(value="target")
    private final Double target;

    @Deprecated
    @ConstructorProperties(value={"name", "statistic", "threshold", "target"})
    public EvaluatedMetric(String name, String statistic, Double threshold, Double target) {
        this.name = name;
        this.statistic = statistic;
        this.threshold = threshold;
        this.target = target;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Double getTarget() {
        return this.target;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EvaluatedMetric(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", statistic=").append(String.valueOf(this.statistic));
        sb.append(", threshold=").append(String.valueOf(this.threshold));
        sb.append(", target=").append(String.valueOf(this.target));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvaluatedMetric)) {
            return false;
        }
        EvaluatedMetric other = (EvaluatedMetric)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.statistic, other.statistic) && Objects.equals(this.threshold, other.threshold) && Objects.equals(this.target, other.target) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.statistic == null ? 43 : this.statistic.hashCode());
        result = result * 59 + (this.threshold == null ? 43 : this.threshold.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="statistic")
        private String statistic;
        @JsonProperty(value="threshold")
        private Double threshold;
        @JsonProperty(value="target")
        private Double target;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder statistic(String statistic) {
            this.statistic = statistic;
            this.__explicitlySet__.add("statistic");
            return this;
        }

        public Builder threshold(Double threshold) {
            this.threshold = threshold;
            this.__explicitlySet__.add("threshold");
            return this;
        }

        public Builder target(Double target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public EvaluatedMetric build() {
            EvaluatedMetric model = new EvaluatedMetric(this.name, this.statistic, this.threshold, this.target);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EvaluatedMetric model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("statistic")) {
                this.statistic(model.getStatistic());
            }
            if (model.wasPropertyExplicitlySet("threshold")) {
                this.threshold(model.getThreshold());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            return this;
        }
    }
}

