/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.optimizer;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.optimizer.Optimizer;
import com.oracle.bmc.optimizer.OptimizerAsyncClient;
import com.oracle.bmc.optimizer.OptimizerPaginators;
import com.oracle.bmc.optimizer.OptimizerWaiters;
import com.oracle.bmc.optimizer.model.Category;
import com.oracle.bmc.optimizer.model.CategoryCollection;
import com.oracle.bmc.optimizer.model.EnrollmentStatus;
import com.oracle.bmc.optimizer.model.EnrollmentStatusCollection;
import com.oracle.bmc.optimizer.model.HistoryCollection;
import com.oracle.bmc.optimizer.model.Profile;
import com.oracle.bmc.optimizer.model.ProfileCollection;
import com.oracle.bmc.optimizer.model.ProfileLevelCollection;
import com.oracle.bmc.optimizer.model.QueryableFieldCollection;
import com.oracle.bmc.optimizer.model.Recommendation;
import com.oracle.bmc.optimizer.model.RecommendationCollection;
import com.oracle.bmc.optimizer.model.RecommendationStrategyCollection;
import com.oracle.bmc.optimizer.model.ResourceAction;
import com.oracle.bmc.optimizer.model.ResourceActionCollection;
import com.oracle.bmc.optimizer.model.WorkRequest;
import com.oracle.bmc.optimizer.model.WorkRequestCollection;
import com.oracle.bmc.optimizer.model.WorkRequestErrorCollection;
import com.oracle.bmc.optimizer.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.optimizer.requests.BulkApplyRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.CreateProfileRequest;
import com.oracle.bmc.optimizer.requests.DeleteProfileRequest;
import com.oracle.bmc.optimizer.requests.FilterResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.GetCategoryRequest;
import com.oracle.bmc.optimizer.requests.GetEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.GetProfileRequest;
import com.oracle.bmc.optimizer.requests.GetRecommendationRequest;
import com.oracle.bmc.optimizer.requests.GetResourceActionRequest;
import com.oracle.bmc.optimizer.requests.GetWorkRequestRequest;
import com.oracle.bmc.optimizer.requests.ListCategoriesRequest;
import com.oracle.bmc.optimizer.requests.ListEnrollmentStatusesRequest;
import com.oracle.bmc.optimizer.requests.ListHistoriesRequest;
import com.oracle.bmc.optimizer.requests.ListProfileLevelsRequest;
import com.oracle.bmc.optimizer.requests.ListProfilesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationStrategiesRequest;
import com.oracle.bmc.optimizer.requests.ListRecommendationsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionQueryableFieldsRequest;
import com.oracle.bmc.optimizer.requests.ListResourceActionsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.optimizer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.optimizer.requests.UpdateEnrollmentStatusRequest;
import com.oracle.bmc.optimizer.requests.UpdateProfileRequest;
import com.oracle.bmc.optimizer.requests.UpdateRecommendationRequest;
import com.oracle.bmc.optimizer.requests.UpdateResourceActionRequest;
import com.oracle.bmc.optimizer.responses.BulkApplyRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.CreateProfileResponse;
import com.oracle.bmc.optimizer.responses.DeleteProfileResponse;
import com.oracle.bmc.optimizer.responses.FilterResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.GetCategoryResponse;
import com.oracle.bmc.optimizer.responses.GetEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.GetProfileResponse;
import com.oracle.bmc.optimizer.responses.GetRecommendationResponse;
import com.oracle.bmc.optimizer.responses.GetResourceActionResponse;
import com.oracle.bmc.optimizer.responses.GetWorkRequestResponse;
import com.oracle.bmc.optimizer.responses.ListCategoriesResponse;
import com.oracle.bmc.optimizer.responses.ListEnrollmentStatusesResponse;
import com.oracle.bmc.optimizer.responses.ListHistoriesResponse;
import com.oracle.bmc.optimizer.responses.ListProfileLevelsResponse;
import com.oracle.bmc.optimizer.responses.ListProfilesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationStrategiesResponse;
import com.oracle.bmc.optimizer.responses.ListRecommendationsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionQueryableFieldsResponse;
import com.oracle.bmc.optimizer.responses.ListResourceActionsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.optimizer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.optimizer.responses.UpdateEnrollmentStatusResponse;
import com.oracle.bmc.optimizer.responses.UpdateProfileResponse;
import com.oracle.bmc.optimizer.responses.UpdateRecommendationResponse;
import com.oracle.bmc.optimizer.responses.UpdateResourceActionResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerClient
extends BaseSyncClient
implements Optimizer {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPTIMIZER").serviceEndpointPrefix("").serviceEndpointTemplate("https://optimizer.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OptimizerAsyncClient.class);
    private final OptimizerWaiters waiters;
    private final OptimizerPaginators paginators;

    private OptimizerClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Optimizer-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OptimizerWaiters(executorService, this);
        this.paginators = new OptimizerPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BulkApplyRecommendationsResponse bulkApplyRecommendations(BulkApplyRecommendationsRequest request) {
        Validate.notBlank((String)request.getRecommendationId(), (String)"recommendationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBulkApplyRecommendationsDetails(), "bulkApplyRecommendationsDetails is required");
        return (BulkApplyRecommendationsResponse)this.clientCall(request, BulkApplyRecommendationsResponse::builder).logger(LOG, "bulkApplyRecommendations").serviceDetails("Optimizer", "BulkApplyRecommendations", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Recommendation/BulkApplyRecommendations").method(Method.POST).requestBuilder(BulkApplyRecommendationsRequest::builder).basePath("/20200606").appendPathParam("recommendations").appendPathParam(request.getRecommendationId()).appendPathParam("actions").appendPathParam("bulkApplyRecommendations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", BulkApplyRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", BulkApplyRecommendationsResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest request) {
        Objects.requireNonNull(request.getCreateProfileDetails(), "createProfileDetails is required");
        return (CreateProfileResponse)this.clientCall(request, CreateProfileResponse::builder).logger(LOG, "createProfile").serviceDetails("Optimizer", "CreateProfile", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Profile/CreateProfile").method(Method.POST).requestBuilder(CreateProfileRequest::builder).basePath("/20200606").appendPathParam("profiles").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Profile.class, CreateProfileResponse.Builder::profile).handleResponseHeaderString("etag", CreateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return (DeleteProfileResponse)this.clientCall(request, DeleteProfileResponse::builder).logger(LOG, "deleteProfile").serviceDetails("Optimizer", "DeleteProfile", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Profile/DeleteProfile").method(Method.DELETE).requestBuilder(DeleteProfileRequest::builder).basePath("/20200606").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public FilterResourceActionsResponse filterResourceActions(FilterResourceActionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        Objects.requireNonNull(request.getQueryDetails(), "queryDetails is required");
        return (FilterResourceActionsResponse)this.clientCall(request, FilterResourceActionsResponse::builder).logger(LOG, "filterResourceActions").serviceDetails("Optimizer", "FilterResourceActions", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ResourceActionSummary/FilterResourceActions").method(Method.POST).requestBuilder(FilterResourceActionsRequest::builder).basePath("/20200606").appendPathParam("actions").appendPathParam("filterResourceActions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("recommendationId", (Object)request.getRecommendationId()).appendQueryParam("recommendationName", (Object)request.getRecommendationName()).appendListQueryParam("childTenancyIds", request.getChildTenancyIds(), CollectionFormatType.Multi).appendQueryParam("includeOrganization", (Object)request.getIncludeOrganization()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResourceActionCollection.class, FilterResourceActionsResponse.Builder::resourceActionCollection).handleResponseHeaderString("opc-request-id", FilterResourceActionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", FilterResourceActionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", FilterResourceActionsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public GetCategoryResponse getCategory(GetCategoryRequest request) {
        Validate.notBlank((String)request.getCategoryId(), (String)"categoryId must not be blank", (Object[])new Object[0]);
        return (GetCategoryResponse)this.clientCall(request, GetCategoryResponse::builder).logger(LOG, "getCategory").serviceDetails("Optimizer", "GetCategory", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Category/GetCategory").method(Method.GET).requestBuilder(GetCategoryRequest::builder).basePath("/20200606").appendPathParam("categories").appendPathParam(request.getCategoryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Category.class, GetCategoryResponse.Builder::category).handleResponseHeaderString("opc-request-id", GetCategoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEnrollmentStatusResponse getEnrollmentStatus(GetEnrollmentStatusRequest request) {
        Validate.notBlank((String)request.getEnrollmentStatusId(), (String)"enrollmentStatusId must not be blank", (Object[])new Object[0]);
        return (GetEnrollmentStatusResponse)this.clientCall(request, GetEnrollmentStatusResponse::builder).logger(LOG, "getEnrollmentStatus").serviceDetails("Optimizer", "GetEnrollmentStatus", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/EnrollmentStatus/GetEnrollmentStatus").method(Method.GET).requestBuilder(GetEnrollmentStatusRequest::builder).basePath("/20200606").appendPathParam("enrollmentStatus").appendPathParam(request.getEnrollmentStatusId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnrollmentStatus.class, GetEnrollmentStatusResponse.Builder::enrollmentStatus).handleResponseHeaderString("etag", GetEnrollmentStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEnrollmentStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProfileResponse getProfile(GetProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        return (GetProfileResponse)this.clientCall(request, GetProfileResponse::builder).logger(LOG, "getProfile").serviceDetails("Optimizer", "GetProfile", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Profile/GetProfile").method(Method.GET).requestBuilder(GetProfileRequest::builder).basePath("/20200606").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Profile.class, GetProfileResponse.Builder::profile).handleResponseHeaderString("etag", GetProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRecommendationResponse getRecommendation(GetRecommendationRequest request) {
        Validate.notBlank((String)request.getRecommendationId(), (String)"recommendationId must not be blank", (Object[])new Object[0]);
        return (GetRecommendationResponse)this.clientCall(request, GetRecommendationResponse::builder).logger(LOG, "getRecommendation").serviceDetails("Optimizer", "GetRecommendation", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Recommendation/GetRecommendation").method(Method.GET).requestBuilder(GetRecommendationRequest::builder).basePath("/20200606").appendPathParam("recommendations").appendPathParam(request.getRecommendationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Recommendation.class, GetRecommendationResponse.Builder::recommendation).handleResponseHeaderString("etag", GetRecommendationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecommendationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetResourceActionResponse getResourceAction(GetResourceActionRequest request) {
        Validate.notBlank((String)request.getResourceActionId(), (String)"resourceActionId must not be blank", (Object[])new Object[0]);
        return (GetResourceActionResponse)this.clientCall(request, GetResourceActionResponse::builder).logger(LOG, "getResourceAction").serviceDetails("Optimizer", "GetResourceAction", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ResourceAction/GetResourceAction").method(Method.GET).requestBuilder(GetResourceActionRequest::builder).basePath("/20200606").appendPathParam("resourceActions").appendPathParam(request.getResourceActionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceAction.class, GetResourceActionResponse.Builder::resourceAction).handleResponseHeaderString("etag", GetResourceActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetResourceActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Optimizer", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20200606").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListCategoriesResponse listCategories(ListCategoriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListCategoriesResponse)this.clientCall(request, ListCategoriesResponse::builder).logger(LOG, "listCategories").serviceDetails("Optimizer", "ListCategories", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/CategorySummary/ListCategories").method(Method.GET).requestBuilder(ListCategoriesRequest::builder).basePath("/20200606").appendPathParam("categories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendListQueryParam("childTenancyIds", request.getChildTenancyIds(), CollectionFormatType.Multi).appendQueryParam("includeOrganization", (Object)request.getIncludeOrganization()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CategoryCollection.class, ListCategoriesResponse.Builder::categoryCollection).handleResponseHeaderString("opc-request-id", ListCategoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCategoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListCategoriesResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListEnrollmentStatusesResponse listEnrollmentStatuses(ListEnrollmentStatusesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEnrollmentStatusesResponse)this.clientCall(request, ListEnrollmentStatusesResponse::builder).logger(LOG, "listEnrollmentStatuses").serviceDetails("Optimizer", "ListEnrollmentStatuses", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/EnrollmentStatusSummary/ListEnrollmentStatuses").method(Method.GET).requestBuilder(ListEnrollmentStatusesRequest::builder).basePath("/20200606").appendPathParam("enrollmentStatus").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnrollmentStatusCollection.class, ListEnrollmentStatusesResponse.Builder::enrollmentStatusCollection).handleResponseHeaderString("opc-request-id", ListEnrollmentStatusesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEnrollmentStatusesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListEnrollmentStatusesResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListHistoriesResponse listHistories(ListHistoriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListHistoriesResponse)this.clientCall(request, ListHistoriesResponse::builder).logger(LOG, "listHistories").serviceDetails("Optimizer", "ListHistories", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/HistorySummary/ListHistories").method(Method.GET).requestBuilder(ListHistoriesRequest::builder).basePath("/20200606").appendPathParam("histories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("recommendationName", (Object)request.getRecommendationName()).appendQueryParam("recommendationId", (Object)request.getRecommendationId()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HistoryCollection.class, ListHistoriesResponse.Builder::historyCollection).handleResponseHeaderString("opc-request-id", ListHistoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListHistoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListHistoriesResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListProfileLevelsResponse listProfileLevels(ListProfileLevelsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListProfileLevelsResponse)this.clientCall(request, ListProfileLevelsResponse::builder).logger(LOG, "listProfileLevels").serviceDetails("Optimizer", "ListProfileLevels", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ProfileLevelSummary/ListProfileLevels").method(Method.GET).requestBuilder(ListProfileLevelsRequest::builder).basePath("/20200606").appendPathParam("profileLevels").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("recommendationName", (Object)request.getRecommendationName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProfileLevelCollection.class, ListProfileLevelsResponse.Builder::profileLevelCollection).handleResponseHeaderString("opc-request-id", ListProfileLevelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProfileLevelsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListProfileLevelsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListProfilesResponse listProfiles(ListProfilesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProfilesResponse)this.clientCall(request, ListProfilesResponse::builder).logger(LOG, "listProfiles").serviceDetails("Optimizer", "ListProfiles", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ProfileSummary/ListProfiles").method(Method.GET).requestBuilder(ListProfilesRequest::builder).basePath("/20200606").appendPathParam("profiles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProfileCollection.class, ListProfilesResponse.Builder::profileCollection).handleResponseHeaderString("opc-request-id", ListProfilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProfilesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListProfilesResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListRecommendationStrategiesResponse listRecommendationStrategies(ListRecommendationStrategiesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListRecommendationStrategiesResponse)this.clientCall(request, ListRecommendationStrategiesResponse::builder).logger(LOG, "listRecommendationStrategies").serviceDetails("Optimizer", "ListRecommendationStrategies", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/RecommendationStrategySummary/ListRecommendationStrategies").method(Method.GET).requestBuilder(ListRecommendationStrategiesRequest::builder).basePath("/20200606").appendPathParam("recommendationStrategies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("recommendationName", (Object)request.getRecommendationName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecommendationStrategyCollection.class, ListRecommendationStrategiesResponse.Builder::recommendationStrategyCollection).handleResponseHeaderString("opc-request-id", ListRecommendationStrategiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecommendationStrategiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRecommendationStrategiesResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListRecommendationsResponse)this.clientCall(request, ListRecommendationsResponse::builder).logger(LOG, "listRecommendations").serviceDetails("Optimizer", "ListRecommendations", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/RecommendationSummary/ListRecommendations").method(Method.GET).requestBuilder(ListRecommendationsRequest::builder).basePath("/20200606").appendPathParam("recommendations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("categoryId", (Object)request.getCategoryId()).appendQueryParam("categoryName", (Object)request.getCategoryName()).appendListQueryParam("childTenancyIds", request.getChildTenancyIds(), CollectionFormatType.Multi).appendQueryParam("includeOrganization", (Object)request.getIncludeOrganization()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecommendationCollection.class, ListRecommendationsResponse.Builder::recommendationCollection).handleResponseHeaderString("opc-request-id", ListRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecommendationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRecommendationsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListResourceActionQueryableFieldsResponse listResourceActionQueryableFields(ListResourceActionQueryableFieldsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListResourceActionQueryableFieldsResponse)this.clientCall(request, ListResourceActionQueryableFieldsResponse::builder).logger(LOG, "listResourceActionQueryableFields").serviceDetails("Optimizer", "ListResourceActionQueryableFields", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/QueryableFieldSummary/ListResourceActionQueryableFields").method(Method.GET).requestBuilder(ListResourceActionQueryableFieldsRequest::builder).basePath("/20200606").appendPathParam("resourceActions").appendPathParam("actions").appendPathParam("getQueryableFields").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryableFieldCollection.class, ListResourceActionQueryableFieldsResponse.Builder::queryableFieldCollection).handleResponseHeaderString("opc-request-id", ListResourceActionQueryableFieldsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceActionQueryableFieldsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListResourceActionQueryableFieldsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListResourceActionsResponse listResourceActions(ListResourceActionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCompartmentIdInSubtree(), "compartmentIdInSubtree is required");
        return (ListResourceActionsResponse)this.clientCall(request, ListResourceActionsResponse::builder).logger(LOG, "listResourceActions").serviceDetails("Optimizer", "ListResourceActions", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ResourceActionSummary/ListResourceActions").method(Method.GET).requestBuilder(ListResourceActionsRequest::builder).basePath("/20200606").appendPathParam("resourceActions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("recommendationId", (Object)request.getRecommendationId()).appendQueryParam("recommendationName", (Object)request.getRecommendationName()).appendListQueryParam("childTenancyIds", request.getChildTenancyIds(), CollectionFormatType.Multi).appendQueryParam("includeOrganization", (Object)request.getIncludeOrganization()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceActionCollection.class, ListResourceActionsResponse.Builder::resourceActionCollection).handleResponseHeaderString("opc-request-id", ListResourceActionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListResourceActionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListResourceActionsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Optimizer", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20200606").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Optimizer", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20200606").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Optimizer", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20200606").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateEnrollmentStatusResponse updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        Validate.notBlank((String)request.getEnrollmentStatusId(), (String)"enrollmentStatusId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEnrollmentStatusDetails(), "updateEnrollmentStatusDetails is required");
        return (UpdateEnrollmentStatusResponse)this.clientCall(request, UpdateEnrollmentStatusResponse::builder).logger(LOG, "updateEnrollmentStatus").serviceDetails("Optimizer", "UpdateEnrollmentStatus", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/EnrollmentStatus/UpdateEnrollmentStatus").method(Method.PUT).requestBuilder(UpdateEnrollmentStatusRequest::builder).basePath("/20200606").appendPathParam("enrollmentStatus").appendPathParam(request.getEnrollmentStatusId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(EnrollmentStatus.class, UpdateEnrollmentStatusResponse.Builder::enrollmentStatus).handleResponseHeaderString("etag", UpdateEnrollmentStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEnrollmentStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest request) {
        Validate.notBlank((String)request.getProfileId(), (String)"profileId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProfileDetails(), "updateProfileDetails is required");
        return (UpdateProfileResponse)this.clientCall(request, UpdateProfileResponse::builder).logger(LOG, "updateProfile").serviceDetails("Optimizer", "UpdateProfile", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Profile/UpdateProfile").method(Method.PUT).requestBuilder(UpdateProfileRequest::builder).basePath("/20200606").appendPathParam("profiles").appendPathParam(request.getProfileId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Profile.class, UpdateProfileResponse.Builder::profile).handleResponseHeaderString("etag", UpdateProfileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProfileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRecommendationResponse updateRecommendation(UpdateRecommendationRequest request) {
        Validate.notBlank((String)request.getRecommendationId(), (String)"recommendationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecommendationDetails(), "updateRecommendationDetails is required");
        return (UpdateRecommendationResponse)this.clientCall(request, UpdateRecommendationResponse::builder).logger(LOG, "updateRecommendation").serviceDetails("Optimizer", "UpdateRecommendation", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/Recommendation/UpdateRecommendation").method(Method.PUT).requestBuilder(UpdateRecommendationRequest::builder).basePath("/20200606").appendPathParam("recommendations").appendPathParam(request.getRecommendationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Recommendation.class, UpdateRecommendationResponse.Builder::recommendation).handleResponseHeaderString("etag", UpdateRecommendationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRecommendationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateResourceActionResponse updateResourceAction(UpdateResourceActionRequest request) {
        Validate.notBlank((String)request.getResourceActionId(), (String)"resourceActionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateResourceActionDetails(), "updateResourceActionDetails is required");
        return (UpdateResourceActionResponse)this.clientCall(request, UpdateResourceActionResponse::builder).logger(LOG, "updateResourceAction").serviceDetails("Optimizer", "UpdateResourceAction", "https://docs.oracle.com/iaas/api/#/en/advisor/20200606/ResourceAction/UpdateResourceAction").method(Method.PUT).requestBuilder(UpdateResourceActionRequest::builder).basePath("/20200606").appendPathParam("resourceActions").appendPathParam(request.getResourceActionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ResourceAction.class, UpdateResourceActionResponse.Builder::resourceAction).handleResponseHeaderString("etag", UpdateResourceActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateResourceActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OptimizerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OptimizerPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OptimizerClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OptimizerClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OptimizerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OptimizerClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OptimizerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OptimizerClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OptimizerClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

