/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAwrSnapshotsRequest
extends BmcRequest<Void> {
    private String awrHubId;
    private String awrSourceDatabaseIdentifier;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getAwrHubId() {
        return this.awrHubId;
    }

    public String getAwrSourceDatabaseIdentifier() {
        return this.awrSourceDatabaseIdentifier;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().awrHubId(this.awrHubId).awrSourceDatabaseIdentifier(this.awrSourceDatabaseIdentifier).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",awrHubId=").append(String.valueOf(this.awrHubId));
        sb.append(",awrSourceDatabaseIdentifier=").append(String.valueOf(this.awrSourceDatabaseIdentifier));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAwrSnapshotsRequest)) {
            return false;
        }
        ListAwrSnapshotsRequest other = (ListAwrSnapshotsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.awrHubId, other.awrHubId) && Objects.equals(this.awrSourceDatabaseIdentifier, other.awrSourceDatabaseIdentifier) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.awrHubId == null ? 43 : this.awrHubId.hashCode());
        result = result * 59 + (this.awrSourceDatabaseIdentifier == null ? 43 : this.awrSourceDatabaseIdentifier.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAwrSnapshotsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String awrHubId = null;
        private String awrSourceDatabaseIdentifier = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder awrHubId(String awrHubId) {
            this.awrHubId = awrHubId;
            return this;
        }

        public Builder awrSourceDatabaseIdentifier(String awrSourceDatabaseIdentifier) {
            this.awrSourceDatabaseIdentifier = awrSourceDatabaseIdentifier;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAwrSnapshotsRequest o) {
            this.awrHubId(o.getAwrHubId());
            this.awrSourceDatabaseIdentifier(o.getAwrSourceDatabaseIdentifier());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAwrSnapshotsRequest build() {
            ListAwrSnapshotsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAwrSnapshotsRequest buildWithoutInvocationCallback() {
            ListAwrSnapshotsRequest request = new ListAwrSnapshotsRequest();
            request.awrHubId = this.awrHubId;
            request.awrSourceDatabaseIdentifier = this.awrSourceDatabaseIdentifier;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeBegin("timeBegin"),
        SnapshotId("snapshotId");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

