/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.opsi.model.IngestHostMetricsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class IngestHostMetricsRequest
extends BmcRequest<IngestHostMetricsDetails> {
    private String id;
    private IngestHostMetricsDetails ingestHostMetricsDetails;
    private String opcRequestId;
    private String ifMatch;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public IngestHostMetricsDetails getIngestHostMetricsDetails() {
        return this.ingestHostMetricsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public IngestHostMetricsDetails getBody$() {
        return this.ingestHostMetricsDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).ingestHostMetricsDetails(this.ingestHostMetricsDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",ingestHostMetricsDetails=").append(String.valueOf((Object)this.ingestHostMetricsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngestHostMetricsRequest)) {
            return false;
        }
        IngestHostMetricsRequest other = (IngestHostMetricsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.ingestHostMetricsDetails, (Object)other.ingestHostMetricsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ingestHostMetricsDetails == null ? 43 : this.ingestHostMetricsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<IngestHostMetricsRequest, IngestHostMetricsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private IngestHostMetricsDetails ingestHostMetricsDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ingestHostMetricsDetails(IngestHostMetricsDetails ingestHostMetricsDetails) {
            this.ingestHostMetricsDetails = ingestHostMetricsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(IngestHostMetricsRequest o) {
            this.id(o.getId());
            this.ingestHostMetricsDetails(o.getIngestHostMetricsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public IngestHostMetricsRequest build() {
            IngestHostMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(IngestHostMetricsDetails body) {
            this.ingestHostMetricsDetails(body);
            return this;
        }

        public IngestHostMetricsRequest buildWithoutInvocationCallback() {
            IngestHostMetricsRequest request = new IngestHostMetricsRequest();
            request.id = this.id;
            request.ingestHostMetricsDetails = this.ingestHostMetricsDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

