/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.opsi.model.AwrReportFormatType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class GetAwrReportRequest
extends BmcRequest<Void> {
    private String awrHubId;
    private String awrSourceDatabaseIdentifier;
    private AwrReportFormatType reportFormat;
    private String instanceNumber;
    private Integer beginSnapshotIdentifierGreaterThanOrEqualTo;
    private Integer endSnapshotIdentifierLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private String opcRequestId;

    public String getAwrHubId() {
        return this.awrHubId;
    }

    public String getAwrSourceDatabaseIdentifier() {
        return this.awrSourceDatabaseIdentifier;
    }

    public AwrReportFormatType getReportFormat() {
        return this.reportFormat;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public Integer getBeginSnapshotIdentifierGreaterThanOrEqualTo() {
        return this.beginSnapshotIdentifierGreaterThanOrEqualTo;
    }

    public Integer getEndSnapshotIdentifierLessThanOrEqualTo() {
        return this.endSnapshotIdentifierLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().awrHubId(this.awrHubId).awrSourceDatabaseIdentifier(this.awrSourceDatabaseIdentifier).reportFormat(this.reportFormat).instanceNumber(this.instanceNumber).beginSnapshotIdentifierGreaterThanOrEqualTo(this.beginSnapshotIdentifierGreaterThanOrEqualTo).endSnapshotIdentifierLessThanOrEqualTo(this.endSnapshotIdentifierLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",awrHubId=").append(String.valueOf(this.awrHubId));
        sb.append(",awrSourceDatabaseIdentifier=").append(String.valueOf(this.awrSourceDatabaseIdentifier));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(",beginSnapshotIdentifierGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnapshotIdentifierGreaterThanOrEqualTo));
        sb.append(",endSnapshotIdentifierLessThanOrEqualTo=").append(String.valueOf(this.endSnapshotIdentifierLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAwrReportRequest)) {
            return false;
        }
        GetAwrReportRequest other = (GetAwrReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.awrHubId, other.awrHubId) && Objects.equals(this.awrSourceDatabaseIdentifier, other.awrSourceDatabaseIdentifier) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.beginSnapshotIdentifierGreaterThanOrEqualTo, other.beginSnapshotIdentifierGreaterThanOrEqualTo) && Objects.equals(this.endSnapshotIdentifierLessThanOrEqualTo, other.endSnapshotIdentifierLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.awrHubId == null ? 43 : this.awrHubId.hashCode());
        result = result * 59 + (this.awrSourceDatabaseIdentifier == null ? 43 : this.awrSourceDatabaseIdentifier.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.beginSnapshotIdentifierGreaterThanOrEqualTo == null ? 43 : this.beginSnapshotIdentifierGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnapshotIdentifierLessThanOrEqualTo == null ? 43 : this.endSnapshotIdentifierLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAwrReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String awrHubId = null;
        private String awrSourceDatabaseIdentifier = null;
        private AwrReportFormatType reportFormat = null;
        private String instanceNumber = null;
        private Integer beginSnapshotIdentifierGreaterThanOrEqualTo = null;
        private Integer endSnapshotIdentifierLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private String opcRequestId = null;

        public Builder awrHubId(String awrHubId) {
            this.awrHubId = awrHubId;
            return this;
        }

        public Builder awrSourceDatabaseIdentifier(String awrSourceDatabaseIdentifier) {
            this.awrSourceDatabaseIdentifier = awrSourceDatabaseIdentifier;
            return this;
        }

        public Builder reportFormat(AwrReportFormatType reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public Builder beginSnapshotIdentifierGreaterThanOrEqualTo(Integer beginSnapshotIdentifierGreaterThanOrEqualTo) {
            this.beginSnapshotIdentifierGreaterThanOrEqualTo = beginSnapshotIdentifierGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnapshotIdentifierLessThanOrEqualTo(Integer endSnapshotIdentifierLessThanOrEqualTo) {
            this.endSnapshotIdentifierLessThanOrEqualTo = endSnapshotIdentifierLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAwrReportRequest o) {
            this.awrHubId(o.getAwrHubId());
            this.awrSourceDatabaseIdentifier(o.getAwrSourceDatabaseIdentifier());
            this.reportFormat(o.getReportFormat());
            this.instanceNumber(o.getInstanceNumber());
            this.beginSnapshotIdentifierGreaterThanOrEqualTo(o.getBeginSnapshotIdentifierGreaterThanOrEqualTo());
            this.endSnapshotIdentifierLessThanOrEqualTo(o.getEndSnapshotIdentifierLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAwrReportRequest build() {
            GetAwrReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAwrReportRequest buildWithoutInvocationCallback() {
            GetAwrReportRequest request = new GetAwrReportRequest();
            request.awrHubId = this.awrHubId;
            request.awrSourceDatabaseIdentifier = this.awrSourceDatabaseIdentifier;
            request.reportFormat = this.reportFormat;
            request.instanceNumber = this.instanceNumber;
            request.beginSnapshotIdentifierGreaterThanOrEqualTo = this.beginSnapshotIdentifierGreaterThanOrEqualTo;
            request.endSnapshotIdentifierLessThanOrEqualTo = this.endSnapshotIdentifierLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

