/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TopProcessesUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="command")
    private final String command;
    @JsonProperty(value="processHash")
    private final String processHash;
    @JsonProperty(value="cpuUsage")
    private final Double cpuUsage;
    @JsonProperty(value="cpuUtilization")
    private final Double cpuUtilization;
    @JsonProperty(value="memoryUtilization")
    private final Double memoryUtilization;
    @JsonProperty(value="virtualMemoryInMBs")
    private final Double virtualMemoryInMBs;
    @JsonProperty(value="physicalMemoryInMBs")
    private final Double physicalMemoryInMBs;
    @JsonProperty(value="maxProcessCount")
    private final Integer maxProcessCount;

    @Deprecated
    @ConstructorProperties(value={"command", "processHash", "cpuUsage", "cpuUtilization", "memoryUtilization", "virtualMemoryInMBs", "physicalMemoryInMBs", "maxProcessCount"})
    public TopProcessesUsage(String command, String processHash, Double cpuUsage, Double cpuUtilization, Double memoryUtilization, Double virtualMemoryInMBs, Double physicalMemoryInMBs, Integer maxProcessCount) {
        this.command = command;
        this.processHash = processHash;
        this.cpuUsage = cpuUsage;
        this.cpuUtilization = cpuUtilization;
        this.memoryUtilization = memoryUtilization;
        this.virtualMemoryInMBs = virtualMemoryInMBs;
        this.physicalMemoryInMBs = physicalMemoryInMBs;
        this.maxProcessCount = maxProcessCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCommand() {
        return this.command;
    }

    public String getProcessHash() {
        return this.processHash;
    }

    public Double getCpuUsage() {
        return this.cpuUsage;
    }

    public Double getCpuUtilization() {
        return this.cpuUtilization;
    }

    public Double getMemoryUtilization() {
        return this.memoryUtilization;
    }

    public Double getVirtualMemoryInMBs() {
        return this.virtualMemoryInMBs;
    }

    public Double getPhysicalMemoryInMBs() {
        return this.physicalMemoryInMBs;
    }

    public Integer getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopProcessesUsage(");
        sb.append("super=").append(super.toString());
        sb.append("command=").append(String.valueOf(this.command));
        sb.append(", processHash=").append(String.valueOf(this.processHash));
        sb.append(", cpuUsage=").append(String.valueOf(this.cpuUsage));
        sb.append(", cpuUtilization=").append(String.valueOf(this.cpuUtilization));
        sb.append(", memoryUtilization=").append(String.valueOf(this.memoryUtilization));
        sb.append(", virtualMemoryInMBs=").append(String.valueOf(this.virtualMemoryInMBs));
        sb.append(", physicalMemoryInMBs=").append(String.valueOf(this.physicalMemoryInMBs));
        sb.append(", maxProcessCount=").append(String.valueOf(this.maxProcessCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopProcessesUsage)) {
            return false;
        }
        TopProcessesUsage other = (TopProcessesUsage)((Object)o);
        return Objects.equals(this.command, other.command) && Objects.equals(this.processHash, other.processHash) && Objects.equals(this.cpuUsage, other.cpuUsage) && Objects.equals(this.cpuUtilization, other.cpuUtilization) && Objects.equals(this.memoryUtilization, other.memoryUtilization) && Objects.equals(this.virtualMemoryInMBs, other.virtualMemoryInMBs) && Objects.equals(this.physicalMemoryInMBs, other.physicalMemoryInMBs) && Objects.equals(this.maxProcessCount, other.maxProcessCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.command == null ? 43 : this.command.hashCode());
        result = result * 59 + (this.processHash == null ? 43 : this.processHash.hashCode());
        result = result * 59 + (this.cpuUsage == null ? 43 : this.cpuUsage.hashCode());
        result = result * 59 + (this.cpuUtilization == null ? 43 : this.cpuUtilization.hashCode());
        result = result * 59 + (this.memoryUtilization == null ? 43 : this.memoryUtilization.hashCode());
        result = result * 59 + (this.virtualMemoryInMBs == null ? 43 : this.virtualMemoryInMBs.hashCode());
        result = result * 59 + (this.physicalMemoryInMBs == null ? 43 : this.physicalMemoryInMBs.hashCode());
        result = result * 59 + (this.maxProcessCount == null ? 43 : this.maxProcessCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="command")
        private String command;
        @JsonProperty(value="processHash")
        private String processHash;
        @JsonProperty(value="cpuUsage")
        private Double cpuUsage;
        @JsonProperty(value="cpuUtilization")
        private Double cpuUtilization;
        @JsonProperty(value="memoryUtilization")
        private Double memoryUtilization;
        @JsonProperty(value="virtualMemoryInMBs")
        private Double virtualMemoryInMBs;
        @JsonProperty(value="physicalMemoryInMBs")
        private Double physicalMemoryInMBs;
        @JsonProperty(value="maxProcessCount")
        private Integer maxProcessCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder command(String command) {
            this.command = command;
            this.__explicitlySet__.add("command");
            return this;
        }

        public Builder processHash(String processHash) {
            this.processHash = processHash;
            this.__explicitlySet__.add("processHash");
            return this;
        }

        public Builder cpuUsage(Double cpuUsage) {
            this.cpuUsage = cpuUsage;
            this.__explicitlySet__.add("cpuUsage");
            return this;
        }

        public Builder cpuUtilization(Double cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            this.__explicitlySet__.add("cpuUtilization");
            return this;
        }

        public Builder memoryUtilization(Double memoryUtilization) {
            this.memoryUtilization = memoryUtilization;
            this.__explicitlySet__.add("memoryUtilization");
            return this;
        }

        public Builder virtualMemoryInMBs(Double virtualMemoryInMBs) {
            this.virtualMemoryInMBs = virtualMemoryInMBs;
            this.__explicitlySet__.add("virtualMemoryInMBs");
            return this;
        }

        public Builder physicalMemoryInMBs(Double physicalMemoryInMBs) {
            this.physicalMemoryInMBs = physicalMemoryInMBs;
            this.__explicitlySet__.add("physicalMemoryInMBs");
            return this;
        }

        public Builder maxProcessCount(Integer maxProcessCount) {
            this.maxProcessCount = maxProcessCount;
            this.__explicitlySet__.add("maxProcessCount");
            return this;
        }

        public TopProcessesUsage build() {
            TopProcessesUsage model = new TopProcessesUsage(this.command, this.processHash, this.cpuUsage, this.cpuUtilization, this.memoryUtilization, this.virtualMemoryInMBs, this.physicalMemoryInMBs, this.maxProcessCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TopProcessesUsage model) {
            if (model.wasPropertyExplicitlySet("command")) {
                this.command(model.getCommand());
            }
            if (model.wasPropertyExplicitlySet("processHash")) {
                this.processHash(model.getProcessHash());
            }
            if (model.wasPropertyExplicitlySet("cpuUsage")) {
                this.cpuUsage(model.getCpuUsage());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilization")) {
                this.cpuUtilization(model.getCpuUtilization());
            }
            if (model.wasPropertyExplicitlySet("memoryUtilization")) {
                this.memoryUtilization(model.getMemoryUtilization());
            }
            if (model.wasPropertyExplicitlySet("virtualMemoryInMBs")) {
                this.virtualMemoryInMBs(model.getVirtualMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("physicalMemoryInMBs")) {
                this.physicalMemoryInMBs(model.getPhysicalMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("maxProcessCount")) {
                this.maxProcessCount(model.getMaxProcessCount());
            }
            return this;
        }
    }
}

