/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class DBExternalInstance
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="cpuCount")
    private final Integer cpuCount;
    @JsonProperty(value="hostMemoryCapacity")
    private final Double hostMemoryCapacity;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="parallel")
    private final String parallel;
    @JsonProperty(value="instanceRole")
    private final String instanceRole;
    @JsonProperty(value="logins")
    private final String logins;
    @JsonProperty(value="databaseStatus")
    private final String databaseStatus;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="edition")
    private final String edition;
    @JsonProperty(value="startupTime")
    private final Date startupTime;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DBExternalInstance(Date timeCollected, String instanceName, String hostName, Integer cpuCount, Double hostMemoryCapacity, String version, String parallel, String instanceRole, String logins, String databaseStatus, String status, String edition, Date startupTime) {
        super(timeCollected);
        this.instanceName = instanceName;
        this.hostName = hostName;
        this.cpuCount = cpuCount;
        this.hostMemoryCapacity = hostMemoryCapacity;
        this.version = version;
        this.parallel = parallel;
        this.instanceRole = instanceRole;
        this.logins = logins;
        this.databaseStatus = databaseStatus;
        this.status = status;
        this.edition = edition;
        this.startupTime = startupTime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public Double getHostMemoryCapacity() {
        return this.hostMemoryCapacity;
    }

    public String getVersion() {
        return this.version;
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getInstanceRole() {
        return this.instanceRole;
    }

    public String getLogins() {
        return this.logins;
    }

    public String getDatabaseStatus() {
        return this.databaseStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public String getEdition() {
        return this.edition;
    }

    public Date getStartupTime() {
        return this.startupTime;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DBExternalInstance(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", cpuCount=").append(String.valueOf(this.cpuCount));
        sb.append(", hostMemoryCapacity=").append(String.valueOf(this.hostMemoryCapacity));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", parallel=").append(String.valueOf(this.parallel));
        sb.append(", instanceRole=").append(String.valueOf(this.instanceRole));
        sb.append(", logins=").append(String.valueOf(this.logins));
        sb.append(", databaseStatus=").append(String.valueOf(this.databaseStatus));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", edition=").append(String.valueOf(this.edition));
        sb.append(", startupTime=").append(String.valueOf(this.startupTime));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBExternalInstance)) {
            return false;
        }
        DBExternalInstance other = (DBExternalInstance)((Object)o);
        return Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.cpuCount, other.cpuCount) && Objects.equals(this.hostMemoryCapacity, other.hostMemoryCapacity) && Objects.equals(this.version, other.version) && Objects.equals(this.parallel, other.parallel) && Objects.equals(this.instanceRole, other.instanceRole) && Objects.equals(this.logins, other.logins) && Objects.equals(this.databaseStatus, other.databaseStatus) && Objects.equals(this.status, other.status) && Objects.equals(this.edition, other.edition) && Objects.equals(this.startupTime, other.startupTime) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.cpuCount == null ? 43 : this.cpuCount.hashCode());
        result = result * 59 + (this.hostMemoryCapacity == null ? 43 : this.hostMemoryCapacity.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.parallel == null ? 43 : this.parallel.hashCode());
        result = result * 59 + (this.instanceRole == null ? 43 : this.instanceRole.hashCode());
        result = result * 59 + (this.logins == null ? 43 : this.logins.hashCode());
        result = result * 59 + (this.databaseStatus == null ? 43 : this.databaseStatus.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.edition == null ? 43 : this.edition.hashCode());
        result = result * 59 + (this.startupTime == null ? 43 : this.startupTime.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="cpuCount")
        private Integer cpuCount;
        @JsonProperty(value="hostMemoryCapacity")
        private Double hostMemoryCapacity;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="parallel")
        private String parallel;
        @JsonProperty(value="instanceRole")
        private String instanceRole;
        @JsonProperty(value="logins")
        private String logins;
        @JsonProperty(value="databaseStatus")
        private String databaseStatus;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="edition")
        private String edition;
        @JsonProperty(value="startupTime")
        private Date startupTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            this.__explicitlySet__.add("cpuCount");
            return this;
        }

        public Builder hostMemoryCapacity(Double hostMemoryCapacity) {
            this.hostMemoryCapacity = hostMemoryCapacity;
            this.__explicitlySet__.add("hostMemoryCapacity");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder parallel(String parallel) {
            this.parallel = parallel;
            this.__explicitlySet__.add("parallel");
            return this;
        }

        public Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            this.__explicitlySet__.add("instanceRole");
            return this;
        }

        public Builder logins(String logins) {
            this.logins = logins;
            this.__explicitlySet__.add("logins");
            return this;
        }

        public Builder databaseStatus(String databaseStatus) {
            this.databaseStatus = databaseStatus;
            this.__explicitlySet__.add("databaseStatus");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder edition(String edition) {
            this.edition = edition;
            this.__explicitlySet__.add("edition");
            return this;
        }

        public Builder startupTime(Date startupTime) {
            this.startupTime = startupTime;
            this.__explicitlySet__.add("startupTime");
            return this;
        }

        public DBExternalInstance build() {
            DBExternalInstance model = new DBExternalInstance(this.timeCollected, this.instanceName, this.hostName, this.cpuCount, this.hostMemoryCapacity, this.version, this.parallel, this.instanceRole, this.logins, this.databaseStatus, this.status, this.edition, this.startupTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DBExternalInstance model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("cpuCount")) {
                this.cpuCount(model.getCpuCount());
            }
            if (model.wasPropertyExplicitlySet("hostMemoryCapacity")) {
                this.hostMemoryCapacity(model.getHostMemoryCapacity());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("parallel")) {
                this.parallel(model.getParallel());
            }
            if (model.wasPropertyExplicitlySet("instanceRole")) {
                this.instanceRole(model.getInstanceRole());
            }
            if (model.wasPropertyExplicitlySet("logins")) {
                this.logins(model.getLogins());
            }
            if (model.wasPropertyExplicitlySet("databaseStatus")) {
                this.databaseStatus(model.getDatabaseStatus());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("edition")) {
                this.edition(model.getEdition());
            }
            if (model.wasPropertyExplicitlySet("startupTime")) {
                this.startupTime(model.getStartupTime());
            }
            return this;
        }
    }
}

